
<?php $__env->startSection('title', __('User Transactions')); ?>

<?php $__env->startPush('header'); ?>
<script type="text/javascript">
    var view_transaction_url = "<?php echo e(route('user.ajax.transactions.view')); ?>";
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="card content-area content-area-mh">
    <div class="card-innr">
        <div class="card-head">
            <h4 class="card-title"><?php echo e(__('Transactions list')); ?></h4>
        </div>
        <div class="gaps-1x"></div>
        <div class="row">
            <div class="col-md-12">
                <div class="float-right position-relative">
                    <a href="#" class="btn btn-light-alt btn-xs dt-filter-text btn-icon toggle-tigger"> <em class="ti ti-settings"></em> </a>
                    <div class="toggle-class toggle-datatable-filter dropdown-content dropdown-dt-filter-text dropdown-content-top-left text-left">
                        <ul class="dropdown-list dropdown-list-s2">
                            <li><h6 class="dropdown-title"><?php echo e(__('Types')); ?></h6></li>
                            <li>
                                <input class="data-filter input-checkbox input-checkbox-sm" type="radio" name="tnx-type" id="type-all" checked value="">
                                <label for="type-all"><?php echo e(__('Any Type')); ?></label>
                            </li>
                            <li>
                                <input class="data-filter input-checkbox input-checkbox-sm" type="radio" name="tnx-type" id="type-purchase" value="Purchase">
                                <label for="type-purchase"><?php echo e(__('Purchase')); ?></label>
                            </li>
                            <?php $__currentLoopData = $has_trnxs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $has): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($has==1): ?>
                            <li>
                                <input class="data-filter input-checkbox input-checkbox-sm" type="radio" name="tnx-type" id="type-<?php echo e($name); ?>" value="<?php echo e(ucfirst($name)); ?>">
                                <label for="type-<?php echo e($name); ?>"><?php echo e(ucfirst($name)); ?></label>
                            </li>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <ul class="dropdown-list dropdown-list-s2">
                            <li><h6 class="dropdown-title"><?php echo e(__('Status')); ?></h6></li>
                            <li>
                                <input class="data-filter input-checkbox input-checkbox-sm" type="radio" name="tnx-status" id="status-all" checked value="">
                                <label for="status-all"><?php echo e(__('Show All')); ?></label>
                            </li>
                            <li>
                                <input class="data-filter input-checkbox input-checkbox-sm" type="radio" name="tnx-status" id="status-approved" value="approved">
                                <label for="status-approved"><?php echo e(__('Approved')); ?></label>
                            </li>
                            <li>
                                <input class="data-filter input-checkbox input-checkbox-sm" type="radio" name="tnx-status" value="pending" id="status-pending">
                                <label for="status-pending"><?php echo e(__('Pending')); ?></label>
                            </li>
                            <li>
                                <input class="data-filter input-checkbox input-checkbox-sm" type="radio" name="tnx-status" value="canceled" id="status-canceled">
                                <label for="status-canceled"><?php echo e(__('Canceled')); ?></label>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <table class="data-table dt-filter-init user-tnx">
            <thead>
                <tr class="data-item data-head">
                    <th class="data-col tnx-status dt-tnxno"><?php echo e(__('Tranx NO')); ?></th>
                    <th class="data-col dt-token"><?php echo e(__('Tokens')); ?></th>
                    <th class="data-col dt-amount"><?php echo e(__('Amount')); ?></th>
                    <th class="data-col dt-base-amount"><?php echo e(base_currency(true)); ?> <?php echo e(__('Amount')); ?></th>
                    <th class="data-col dt-account"><?php echo e(__('To')); ?></th>
                    <th class="data-col dt-type tnx-type"><div class="dt-type-text"><?php echo e(__('Type')); ?></div></th>
                    <th class="data-col"></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $trnxs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trnx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php 
                    $text_danger = ( $trnx->tnx_type=='refund' || ($trnx->tnx_type=='transfer' && $trnx->extra=='sent') ) ? ' text-danger' : '';
                ?>
                <tr class="data-item tnx-item-<?php echo e($trnx->id); ?>">
                    <td class="data-col dt-tnxno">
                        <div class="d-flex align-items-center">
                            <div class="data-state data-state-<?php echo e(str_replace(['progress','canceled'], ['pending','canceled'], __status($trnx->status, 'icon'))); ?>">
                                <span class="d-none"><?php echo e(($trnx->status=='onhold') ? ucfirst('pending') : ucfirst($trnx->status)); ?></span>
                            </div>
                            <div class="fake-class">
                                <span class="lead tnx-id"><?php echo e($trnx->tnx_id); ?></span>
                                <span class="sub sub-date"><?php echo e(_date($trnx->tnx_time)); ?></span>
                            </div>
                        </div>
                    </td>
                    <td class="data-col dt-token">
                        <span class="lead token-amount<?php echo e($text_danger); ?>"><?php echo e((starts_with($trnx->total_tokens, '-') ? '' : '+').to_num_token($trnx->total_tokens)); ?></span>
                        <span class="sub sub-symbol"><?php echo e(token_symbol()); ?></span>
                    </td>
                    <td class="data-col dt-amount<?php echo e($text_danger); ?>">
                        <?php if($trnx->tnx_type=='referral'||$trnx->tnx_type=='bonus'): ?> 
                            <span class="lead amount-pay"><?php echo e('~'); ?></span>
                        <?php else: ?> 
                        <span class="lead amount-pay<?php echo e($text_danger); ?>"><?php echo e(to_num($trnx->amount, 'max')); ?></span>
                        <span class="sub sub-symbol"><?php echo e(strtoupper($trnx->currency)); ?> <em class="fas fa-info-circle" data-toggle="tooltip" data-placement="bottom" title="1 <?php echo e(token('symbol')); ?> = <?php echo e(to_num($trnx->currency_rate, 'max').' '.strtoupper($trnx->currency)); ?>"></em></span>
                        <?php endif; ?>
                    </td>
                    <td class="data-col dt-usd-amount">
                        <?php if($trnx->tnx_type=='referral'||$trnx->tnx_type=='bonus'): ?> 
                            <span class="lead amount-pay"><?php echo e('~'); ?></span>
                        <?php else: ?> 
                        <span class="lead amount-pay<?php echo e($text_danger); ?>"><?php echo e(to_num($trnx->base_amount, 'auto')); ?></span>
                        <span class="sub sub-symbol"><?php echo e(base_currency(true)); ?> <em class="fas fa-info-circle" data-toggle="tooltip" data-placement="bottom" title="1 <?php echo e(token('symbol')); ?> = <?php echo e(to_num($trnx->base_currency_rate, 'max').' '.base_currency(true)); ?>"></em></span>
                        <?php endif; ?>
                    </td>
                    <td class="data-col dt-account">
                        <?php 
                        $pay_to = ($trnx->payment_method=='system') ? '~' : ( ($trnx->payment_method=='bank') ? explode(',', $trnx->payment_to) : show_str($trnx->payment_to) );
                        $extra = ($trnx->tnx_type == 'refund') ? (is_json($trnx->extra, true) ?? $trnx->extra) : '';
                        ?>
                        <?php if($trnx->tnx_type == 'refund'): ?>
                            <span class="sub sub-info"><?php echo e($trnx->details); ?></span>
                            <?php if($extra->trnx): ?>
                            <span class="sub sub-view"><a href="javascript:void(0)" class="view-transaction" data-id="<?php echo e($extra->trnx); ?>"><?php echo e(__("View Transaction")); ?></a></span>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php if($trnx->refund != null): ?>
                            <span class="sub sub-info text-danger"><?php echo e(__('Refunded #:orderid', ['orderid' => set_id($trnx->refund, 'refund')])); ?></span>
                            <?php else: ?>
                            <span class="lead user-info"><?php echo e(($trnx->payment_method=='bank') ? $pay_to[0] : ( ($pay_to) ? $pay_to : '~' )); ?></span>
                            <?php endif; ?>
                            <span class="sub sub-date"><?php echo e(($trnx->checked_time) ? _date($trnx->checked_time) : _date($trnx->created_at)); ?></span>
                        <?php endif; ?>
                    </td>
                    <td class="data-col dt-type">
                        <span class="dt-type-md badge badge-outline badge-md badge-<?php echo e(__(__status($trnx->tnx_type,'status'))); ?>"><?php echo e(__(ucfirst($trnx->tnx_type))); ?></span>
                        <span class="dt-type-sm badge badge-sq badge-outline badge-md badge-<?php echo e(__(__status($trnx->tnx_type, 'status'))); ?>"><?php echo e(ucfirst(substr($trnx->tnx_type, 0,1))); ?></span>
                    </td>
                    <td class="data-col text-right">
                        <?php if($trnx->status == 'pending' || $trnx->status == 'onhold'): ?>
                            <?php if($trnx->tnx_type != 'transfer'): ?>
                            <div class="relative d-inline-block d-md-none">
                                <a href="#" class="btn btn-light-alt btn-xs btn-icon toggle-tigger"><em class="ti ti-more-alt"></em></a>
                                <div class="toggle-class dropdown-content dropdown-content-center-left pd-2x">
                                    <ul class="data-action-list">
                                        <li><a href="javascript:void(0)" class="btn btn-auto btn-primary btn-xs view-transaction" data-id="<?php echo e($trnx->id); ?>"><span><?php echo e(__('Pay')); ?></span><em class="ti ti-wallet"></em></a></li>
                                        <?php if($trnx->checked_time != NUll): ?>
                                        <li><a href="<?php echo e(route('user.ajax.transactions.delete', $trnx->id)); ?>" class="btn btn-danger-alt btn-xs btn-icon user_tnx_trash" data-tnx_id="<?php echo e($trnx->id); ?>"><em class="ti ti-trash"></em></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>

                            <ul class="data-action-list d-none d-md-inline-flex">
                                <li><a href="javascript:void(0)" class="btn btn-auto btn-primary btn-xs view-transaction" data-id="<?php echo e($trnx->id); ?>"><span><?php echo e(__('Pay')); ?></span><em class="ti ti-wallet"></em></a></li>
                                <?php if($trnx->checked_time != NUll): ?>
                                <li><a href="<?php echo e(route('user.ajax.transactions.delete', $trnx->id)); ?>" class="btn btn-danger-alt btn-xs btn-icon user_tnx_trash" data-tnx_id="<?php echo e($trnx->id); ?>"><em class="ti ti-trash"></em></a></li>
                                <?php endif; ?>
                            </ul>
                            <?php else: ?> 
                                <a href="javascript:void(0)" class="view-transaction btn btn-light-alt btn-xs btn-icon" data-id="<?php echo e($trnx->id); ?>"><em class="ti ti-eye"></em></a>
                            <?php endif; ?>
                        <?php else: ?>
                        <a href="javascript:void(0)" class="view-transaction btn btn-light-alt btn-xs btn-icon" data-id="<?php echo e($trnx->id); ?>"><em class="ti ti-eye"></em></a>
                            <?php if($trnx->checked_time == NUll && ($trnx->status == 'rejected' || $trnx->status == 'canceled')): ?>
                            <a href="<?php echo e(route('user.ajax.transactions.delete', $trnx->id)); ?>" class="btn btn-danger-alt btn-xs btn-icon user_tnx_trash" data-tnx_id="<?php echo e($trnx->id); ?>"><em class="ti ti-trash"></em></a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/user/transactions.blade.php ENDPATH**/ ?>