
<?php $__env->startSection('title', __(':symbol Token Balance', ['symbol' => token_symbol()])); ?>
<?php
$has_sidebar = true;
$symbol = token_symbol();
$base_symbol = base_currency(1);
$TAC = $token_account;
$TST = $token_stages;
// dd($TST);
?>
<?php $__env->startSection('content'); ?>
<div class="content-area card">
    <div class="card-innr">
        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="card-head">
            <h4 class="card-title"><?php echo e(__('My :symbol Token', ['symbol'=> $symbol])); ?></h4>
        </div>
        <div class="gaps-1x"></div>

        <div class="card-bordered nopd">
            <div class="card-innr">
                <div class="row guttar-vr-15px align-items-center">
                    <div class="col-md-8">
                        <div class="total-block">
                            <h6 class="total-title ucap"><?php echo e(__('Token Balance')); ?></h6>
                            <span class="total-amount-lead"><?php echo e(to_num_token($TAC->current).' '.$symbol); ?>

                                <?php if($TAC->pending > 0): ?>
                                <em class="align-middle fas fa-info-circle fs-12 text-light" data-toggle="tooltip" data-placement="right" title="<?php echo e(__('+:amount :symbol Pending Request', ['amount' => to_num_token($TAC->pending), 'symbol' => $symbol])); ?>"></em>
                                <?php endif; ?>
                            </span>
                            <p class="total-note"><?php echo e(__('Equivalent to')); ?> <span><?php echo e(to_num($TAC->current_in_base, 'max').' '.$base_symbol); ?></span></p>
                        </div>
                    </div>
                    <div class="col-md-4 text-md-right">
                        <a href="<?php echo e(route('user.token')); ?>" class="btn btn-primary"><?php echo e(__('Buy More Token')); ?></a>
                    </div>
                </div>
            </div>
            <div class="sap sap-light"></div>
            <div class="card-innr">
                <div class="total-block">
                    <h5 class="total-title-sm"><?php echo e(__('Total Token Amount')); ?></h5>
                    <span class="total-amount"><?php echo e(to_num_token($TAC->total).' '.$symbol); ?></span>
                </div>
                <div class="total-block">
                    <ul class="list total-wg">
                        <li>
                            <span class="total-title-xs"><?php echo e(__('Purchased Token')); ?></span>
                            <span class="total-amount-sm"><?php echo e(to_num_token($TAC->purchased).' '.$symbol); ?></span>
                        </li>
                        <li>
                            <span class="total-title-xs"><?php echo e(__('Referral Token')); ?></span>
                            <span class="total-amount-sm"><?php echo e(to_num_token($TAC->referral).' '.$symbol); ?></span>
                        </li>
                        <li>
                            <span class="total-title-xs"><?php echo e(__('Bonuses Token')); ?></span>
                            <span class="total-amount-sm"><?php echo e(to_num_token($TAC->bonuses).' '.$symbol); ?></span>
                        </li>
                    </ul>
                    <?php if($TAC->has_withdraw || $TAC->has_transfer): ?>
                    <ul class="list total-wg">
                        <?php if($TAC->has_withdraw): ?>
                        <li>
                            <span class="total-title-xs"><?php echo e(__('Withdraw Token')); ?></span>
                            <span class="total-amount-sm"><?php echo e(to_num_token($TAC->withdraw).' '.$symbol); ?></span>
                        </li>
                        <?php endif; ?>
                        <?php if($TAC->has_transfer): ?>
                        <li>
                            <span class="total-title-xs"><?php echo e(__('Transfer Token')); ?></span>
                            <span class="total-amount-sm"><?php echo e(to_num_token($TAC->transfer).' '.$symbol); ?></span>
                        </li>
                        <?php endif; ?>
                    </ul>
                    <?php endif; ?>
                </div>
            </div>
            <div class="sap sap-light"></div>
            <div class="card-innr">
                <div class="total-block">
                    <h5 class="total-title-sm"><?php echo e(__('Total Contributed')); ?></h5>
                    <span class="total-amount"><?php echo e(to_num($TAC->contributed, 'max').' '.$base_symbol); ?></span>
                </div>
                <?php if(!empty($TAC->contribute_in)): ?>
                <div class="total-block total-block-lg">
                    <h6 class="total-title-xs ucap"><?php echo e(__('In Currency')); ?></h6>
                    <ul class="list total-wg">
                        <?php $__currentLoopData = $TAC->contribute_in; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cur => $amt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <span class="total-amount-sm"><?php echo e(to_num($amt, 'max')); ?></span>
                            <span class="total-title-xs"><?php echo e(strtoupper($cur)); ?></span>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
            </div>
            <?php $__currentLoopData = $user_modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(!empty($opt) && $opt->enable==1): ?>
            <div class="sap sap-light"></div>
            <div class="card-innr">
                <div class="row guttar-vr-15px align-items-center">
                    <div class="col-md-8">
                        <div class="text-block mgmb-0-5x">
                            <h6 class="text-title-xs"><?php echo e($opt->title); ?></h6>
                            <p class="small"><?php echo e($opt->desc); ?></p>
                            <?php if(!empty($opt->view_route) && $opt->view): ?>
                            <a href="<?php echo e(route($opt->view_route)); ?>" class="link link-primary<?php echo e($opt->view_class); ?>"><span><?php echo e($opt->view); ?></span> <em class="icon fa fa-angle-right"></em></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if($opt->cta): ?>
                    <div class="col-md-4 text-md-right">
                        <a href="<?php echo e((!empty($opt->cta_route) && has_route($opt->cta_route)) ? route($opt->cta_route) : 'javascript:void(0)'); ?>" class="btn btn-primary btn-sm btn-sm-min<?php echo e($opt->cta_class); ?>"<?php echo (($opt->cta_daction) ? ' data-action="'.$opt->cta_daction.'"' : '').(($opt->cta_dtype) ? ' data-type="'.$opt->cta_dtype.'"' : ''); ?>><?php echo e(__($opt->cta)); ?></a>
                    </div>
                    <?php endif; ?>
                </div>
                <?php if($opt->status==1 && $opt->message): ?> 
                    <p class="fs-11 text-danger mt-3"><em><?php echo e($opt->message); ?></em></p>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<?php if(gws('user_mytoken_stage')==1 && !empty($TST)): ?>
<div class="content-area card">
    <div class="card-innr card-innr-fix-x">
        <div class="row guttar-25px guttar-vr-25px">
            <?php $__currentLoopData = $TST; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ST): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6">
                <div class="card-bordered nopd">
                    <div class="card-innr">
                        <div class="total-block">
                            <h6 class="total-title-xs ucap"><?php echo e(__('Stage Name')); ?></h6>
                            <span class="total-title-lead"><?php echo e($ST->name); ?></span>
                        </div>
                        <div class="total-block total-block-md">
                            <h6 class="total-title-xs"><?php echo e(__('Total Token')); ?></h6>
                            <span class="total-amount-lg"><?php echo e(to_num_token($ST->token).' '.$symbol); ?></span>
                        </div>
                    </div>
                    <div class="sap sap-light"></div>
                    <div class="card-innr">
                        <div class="total-block">
                            <h6 class="total-title-xs"><?php echo e(__('Purchased Token')); ?></h6>
                            <span class="total-amount"><?php echo e(to_num_token($ST->purchase).' '.$symbol); ?></span>
                        </div>
                        <div class="total-block">
                            <ul class="list list-col2x guttar-vr-16px">
                                <li>
                                    <span class="total-title-xs"><?php echo e(__('Bonus')); ?></span>
                                    <span class="total-amount-sm"><?php echo e(to_num_token($ST->bonus).' '.$symbol); ?></span>
                                </li>
                                <li>
                                    <span class="total-title-xs"><?php echo e(__('Referral')); ?></span>
                                    <span class="total-amount-sm"><?php echo e(to_num_token($ST->referral).' '.$symbol); ?></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="sap sap-light"></div>
                    <div class="card-innr">
                        <div class="has-action">
                            <div class="total-block">
                                <h6 class="total-title-xs"><?php echo e(__('Total Contributed')); ?></h6>
                                <span class="total-amount"><?php echo e(to_num($ST->contribute, 'max').' '.$base_symbol); ?></span>
                            </div>
                            <?php if(!empty($ST->contribute_in)): ?>
                            <div class="total-action">
                                <a href="#" class="toggle-tigger"><em class="ti ti-more-alt"></em></a>
                                <div class="toggle-class dropdown-content dropdown-content-md dropdown-content-up-left">
                                    <div class="total-block">
                                        <h6 class="total-title-xs ucap mb-2"><?php echo e(__('In Currency')); ?></h6>
                                        <ul class="list guttar-vr-12px">
                                            <?php $__currentLoopData = $ST->contribute_in; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cur => $amt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <span class="total-amount-sm"><?php echo e(to_num($amt, 'max')); ?></span>
                                                <span class="total-title-xs"><?php echo e(strtoupper($cur)); ?></span>
                                            </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/user/account-token.blade.php ENDPATH**/ ?>