
<?php $__env->startSection('title', ucfirst($is_page).' Transactions'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
    <div class="container">
        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('vendor.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="card content-area content-area-mh">
            <div class="card-innr">
                <div class="card-head has-aside">
                    <h4 class="card-title"><?php echo e(ucfirst($is_page)); ?> Transactions</h4>
                    <div class="card-opt">
                        <ul class="btn-grp btn-grp-block guttar-20px">
                            <li>
                                <a href="javascript:void(0)" class="btn btn-sm btn-auto btn-primary addTnx">
                                    <em class="fas fa-plus-circle"></em><span>Add <span class="d-none d-sm-inline-block">Tokens</span></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="page-nav-wrap">
                    <div class="page-nav-bar justify-content-between bg-lighter">
                        <div class="page-nav w-100 w-lg-auto">
                            <ul class="nav">
                                <li class="nav-item<?php echo e((is_page('transactions.pending') ? ' active' : '')); ?>"><a class="nav-link" href="<?php echo e(route('admin.transactions', 'pending')); ?>">Pending</a></li>
                                <li class="nav-item <?php echo e((is_page('transactions.approved') ? ' active' : '')); ?>"><a class="nav-link" href="<?php echo e(route('admin.transactions', 'approved')); ?>">Approved</a></li>
                                <li class="nav-item <?php echo e((is_page('transactions.bonuses') ? ' active' : '')); ?>"><a class="nav-link" href="<?php echo e(route('admin.transactions', 'bonuses')); ?>">Bonuses</a></li>
                                <li class="nav-item <?php echo e((is_page('transactions') ? ' active' : '')); ?>"><a class="nav-link" href="<?php echo e(route('admin.transactions')); ?>">All</a></li>
                            </ul>
                        </div>
                        <div class="search flex-grow-1 pl-lg-4 w-100 w-sm-auto">
                            <form action="<?php echo e(route('admin.transactions')); ?>" method="GET" autocomplete="off">
                                <div class="input-wrap">
                                    <span class="input-icon input-icon-left"><em class="ti ti-search"></em></span>
                                    <input type="search" class="input-solid input-transparent" placeholder="Tranx ID to quick search" value="<?php echo e(request()->get('s', '')); ?>" name="s">
                                </div>
                            </form>
                        </div>
                        <?php if(!empty(env_file()) && nio_status() && !empty(app_key())): ?>
                        <div class="tools w-100 w-sm-auto">
                            <ul class="btn-grp guttar-8px">
                                <li><a href="#" class="btn btn-light btn-sm btn-icon btn-outline bg-white advsearch-opt"> <em class="ti ti-panel"></em> </a></li>
                                <?php if(is_super_admin()): ?>
                                <li>
                                    <div class="relative">
                                        <a href="#" class="btn btn-light bg-white btn-sm btn-icon toggle-tigger btn-outline"><em class="ti ti-server"></em> </a>
                                        <div class="toggle-class dropdown-content dropdown-content-sm dropdown-content-center shadow-soft">
                                            <ul class="dropdown-list">
                                                <li><h6 class="dropdown-title">Export</h6></li>
                                                <li><a href="<?php echo e(route('admin.export', array_merge([ 'table' => 'transactions', 'format' => 'entire'], request()->all()))); ?>">Entire</a></li>
                                                <li><a href="<?php echo e(route('admin.export', array_merge([ 'table' => 'transactions', 'format' => 'minimal'], request()->all()))); ?>">Minimal</a></li>
                                                <li><a href="<?php echo e(route('admin.export', array_merge([ 'table' => 'transactions', 'format' => 'compact'], request()->all()))); ?>">Compact</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </li>
                                <?php endif; ?>
                                <li>
                                    <div class="relative">
                                        <a href="#" class="btn btn-light bg-white btn-sm btn-icon toggle-tigger btn-outline"><em class="ti ti-settings"></em> </a>
                                        <div class="toggle-class dropdown-content dropdown-content-sm dropdown-content-center shadow-soft">
                                            <form class="update-meta" action="#" data-type="tnx_page_meta">
                                                <ul class="dropdown-list">
                                                    <li><h6 class="dropdown-title">Show</h6></li>
                                                    <li<?php echo (gmvl('tnx_per_page', 10)==10) ? ' class="active"' : ''; ?>>
                                                        <a href="#" data-meta="perpage=10">10</a></li>
                                                    <li<?php echo (gmvl('tnx_per_page', 10)==20) ? ' class="active"' : ''; ?>>
                                                        <a href="#" data-meta="perpage=20">20</a></li>
                                                    <li<?php echo (gmvl('tnx_per_page', 10)==50) ? ' class="active"' : ''; ?>>
                                                        <a href="#" data-meta="perpage=50">50</a></li>
                                                </ul>
                                                <ul class="dropdown-list">
                                                    <li><h6 class="dropdown-title">Order</h6></li>
                                                    <li<?php echo (gmvl('tnx_ordered', 'DESC')=='DESC') ? ' class="active"' : ''; ?>>
                                                        <a href="#" data-meta="ordered=DESC">DESC</a></li>
                                                    <li<?php echo (gmvl('tnx_ordered', 'DESC')=='ASC') ? ' class="active"' : ''; ?>>
                                                        <a href="#" data-meta="ordered=ASC">ASC</a></li>
                                                </ul>
                                            </form>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php if( !empty(env_file()) && nio_status() && !empty(app_key()) ): ?>
                    <div class="search-adv-wrap hide">
                        <form class="adv-search" id="adv-search" action="<?php echo e(route('admin.transactions')); ?>" method="GET" autocomplete="off">
                            <div class="row align-items-end guttar-20px guttar-vr-15px">
                                <div class="col-lg-6">
                                    <div class="input-grp-wrap">
                                        <span class="input-item-label input-item-label-s2 text-exlight">Advanced Search</span>
                                        <div class="input-grp align-items-center bg-white">
                                            <div class="input-wrap flex-grow-1">
                                                <input value="<?php echo e(request()->get('search')); ?>" class="input-solid input-solid-sm input-transparent" type="text" placeholder="Search by ID" name="search">
                                            </div>
                                            <ul class="search-type">
                                                <li class="input-wrap input-radio-wrap">
                                                    <input name="by" class="input-radio-select" id="advs-by-tnx" value="" type="radio"<?php echo e((empty(request()->by) || request()->by!='usr') ? ' checked' : ''); ?>>
                                                    <label for="advs-by-tnx">TRANX</label>
                                                </li>
                                                <li class="input-wrap input-radio-wrap">
                                                    <input name="by" class="input-radio-select" id="advs-by-user" value="usr" type="radio"<?php echo e((isset(request()->by) && request()->by=='usr') ? ' checked' : ''); ?>>
                                                    <label for="advs-by-user">User</label>
                                                </li>
                                                <li class="input-wrap input-radio-wrap">
                                                    <input name="by" class="input-radio-select" id="advs-by-wallet_address" value="wallet_address" type="radio"<?php echo e((isset(request()->by) && request()->by=='wallet_address') ? ' checked' : ''); ?>>
                                                    <label for="advs-by-wallet_address">Reference</label>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-4 col-mb-6">
                                    <div class="input-wrap input-with-label">
                                        <label class="input-item-label input-item-label-s2 text-exlight">Tranx Type</label>
                                        <select  name="type" class="select select-sm select-block select-bordered" data-dd-class="search-off">
                                            <option value="">Any Type</option>
                                            <option <?php echo e(request()->get('type') == 'purchase' ? 'selected' : ''); ?> value="purchase">Purchase</option>
                                            <option <?php echo e(request()->get('type') == 'bonus' ? 'selected' : ''); ?> value="bonus">Bonus</option>
                                            <option <?php echo e(request()->get('type') == 'referral' ? 'selected' : ''); ?> value="referral">Referral</option>
                                            <option <?php echo e(request()->get('type') == 'transfer' ? 'selected' : ''); ?> value="transfer">Transfer</option>
                                            <option <?php echo e(request()->get('type') == 'refund' ? 'selected' : ''); ?> value="refund">Refund</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-4 col-mb-6">
                                    <div class="input-wrap input-with-label">
                                        <label class="input-item-label input-item-label-s2 text-exlight">Status</label>
                                        <select name="state" class="select select-sm select-block select-bordered" data-dd-class="search-off">
                                            <option value="">Show All</option>
                                            <option <?php echo e(request()->get('state') == 'pending' ? 'selected' : ''); ?> value="pending">Pending</option>
                                            <option <?php echo e(request()->get('state') == 'onhold' ? 'selected' : ''); ?> value="onhold">Onhold</option>
                                            <option <?php echo e(request()->get('state') == 'approved' ? 'selected' : ''); ?> value="approved">Approved</option>
                                            <option <?php echo e(request()->get('state') == 'canceled' ? 'selected' : ''); ?> value="canceled">Canceled</option>
                                            <option <?php echo e(request()->get('state') == 'deleted' ? 'selected' : ''); ?> value="deleted">Deleted</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-sm-4 col-mb-6">
                                    <div class="input-wrap input-with-label">
                                        <label class="input-item-label input-item-label-s2 text-exlight">Stage</label>
                                        <select name="stg" class="select select-sm select-block select-bordered" data-dd-class="search-off">
                                            <option value="">All Stage</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <option <?php echo e(request()->get('stg') == $stage->id ? 'selected' : ''); ?> value="<?php echo e($stage->id); ?>"><?php echo e($stage->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <option value="">No active stage</option>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-lg-2 col-mb-6">
                                    <div class="input-wrap input-with-label">
                                        <label class="input-item-label input-item-label-s2 text-exlight">Pay Method</label>
                                        <select name="pmg" class="select select-sm select-block select-bordered" data-dd-class="search-off">
                                            <option value="">All</option>
                                            <?php $__currentLoopData = $gateway; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pmg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(request()->get('pmg') == $pmg ? 'selected' : ''); ?> value="<?php echo e($pmg); ?>"><?php echo e(ucfirst($pmg)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-lg-2 col-mb-6">
                                    <div class="input-wrap input-with-label">
                                        <label class="input-item-label input-item-label-s2 text-exlight">Pay Currency</label>
                                        <select name="pmc" class="select select-sm select-block select-bordered" data-dd-class="search-off">
                                            <option value="">All</option>
                                            <?php $__currentLoopData = $pm_currency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gt => $full): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(token('purchase_'.$gt) == 1): ?>
                                            <option <?php echo e(request()->get('pmc') == $gt ? 'selected' : ''); ?> value="<?php echo e(strtolower($gt)); ?>"><?php echo e(strtoupper($gt)); ?></option>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-lg-2 col-mb-6">
                                    <div class="input-wrap input-with-label">
                                        <label class="input-item-label input-item-label-s2 text-exlight">Date Within</label>
                                        <select name="date" class="select select-sm select-block select-bordered date-opt" data-dd-class="search-off">
                                            <option value="">All Time</option>
                                            <option <?php echo e(request()->get('date') == 'today' ? 'selected' : ''); ?> value="today">Today</option>
                                            <option <?php echo e(request()->get('date') == 'this-month' ? 'selected' : ''); ?> value="this-month">This Month</option>
                                            <option <?php echo e(request()->get('date') == 'last-month' ? 'selected' : ''); ?> value="last-month">Last Month</option>
                                            <option <?php echo e(request()->get('date') == '90day' ? 'selected' : ''); ?> value="90day">Last 90 Days</option>
                                            <option <?php echo e(request()->get('date') == 'custom' ? 'selected' : ''); ?> value="custom">Custom Range</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-lg-2 col-mb-6 date-hide-show">
                                    <div class="input-wrap input-with-label">
                                        <label class="input-item-label input-item-label-s2 text-exlight">From</label>
                                        <div class="relative">
                                            <input class="input-bordered input-solid-sm date-picker bg-white" value="<?php echo e((request()->get('date') == 'custom') ? request()->get('from') : ''); ?>" type="text" id="date-from" name="from" data-format="alt">
                                            <span class="input-icon input-icon-right date-picker-icon"><em class="ti ti-calendar"></em></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-lg-2 col-mb-6 date-hide-show">
                                    <div class="input-wrap input-with-label">
                                        <label class="input-item-label input-item-label-s2 text-exlight">To</label>
                                        <div class="relative">
                                            <input class="input-bordered input-solid-sm date-picker bg-white" value="<?php echo e((request()->get('date') == 'custom') ? request()->get('to') : ''); ?>" type="text" id="date-to" name="to" data-format="alt">
                                            <span class="input-icon input-icon-right date-picker-icon"><em class="ti ti-calendar"></em></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-lg-2 col-mb-6">
                                    <div class="input-wrap">
                                        <input type="hidden" name="filter" value="1">
                                        <button class="btn btn-sm btn-sm-s2 btn-auto btn-primary">
                                            <em class="ti ti-search width-auto"></em><span>Search</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <?php endif; ?>

                    <?php if(request()->get('filter') || request()->s): ?>
                    <div class="search-adv-result">
                        <div class="search-info">
                            Found <span class="search-count"><?php echo e($trnxs->total()); ?></span> Transactions<?php echo e((request()->get('date') != 'custom') ? '.' : ''); ?>

                            <?php if(request()->get('date') == 'custom'): ?>
                            between <span><?php echo e(_date2sz(request()->get('from'), '', true)); ?></span> to <span><?php echo e(_date2sz(request()->get('to'), '', true)); ?></span>.
                            <?php endif; ?>
                        </div>
                        <ul class="search-opt">
                            <?php if(request()->get('search')): ?>
                            <li><a href="<?php echo e(qs_url(qs_filter('search'))); ?>">Search <span>'<?php echo e(request()->get('search')); ?>'</span><?php echo e((request()->by=='usr') ? ' (User)' : ''); ?></a></li>
                            <?php endif; ?>

                            <?php if(request()->get('type')): ?>
                                <li><a href="<?php echo e(qs_url( qs_filter('type'))); ?>">Type: <span><?php echo e(ucfirst(request()->get('type'))); ?></span></a></li>
                            <?php endif; ?>

                            <?php if(request()->get('state')): ?>
                                <li><a href="<?php echo e(qs_url( qs_filter('state'))); ?>">Status: <span><?php echo e(ucfirst(request()->get('state'))); ?></span></a></li>
                            <?php endif; ?>

                            <?php if(request()->get('stg')): ?>
                                <li><a href="<?php echo e(qs_url( qs_filter('stg'))); ?>">Stage: <span><?php echo e(ucfirst(request()->get('stg'))); ?></span></a></li>
                            <?php endif; ?>

                            <?php if(request()->get('pmg')): ?>
                                <li><a href="<?php echo e(qs_url( qs_filter('pmg'))); ?>">Pay Method: <span><?php echo e(ucfirst(request()->get('pmg'))); ?></span></a></li>
                            <?php endif; ?>

                            <?php if(request()->get('pmc')): ?>
                                <li><a href="<?php echo e(qs_url( qs_filter('pmc'))); ?>">Currency: <span><?php echo e(strtoupper(request()->get('pmc'))); ?></span></a></li>
                            <?php endif; ?>

                            <?php if(request()->get('date') == 'today'): ?>
                                <li><a href="<?php echo e(qs_url( qs_filter('date'))); ?>">In today</span></a></li>
                            <?php endif; ?>

                            <?php if(request()->get('date') == 'this-month'): ?>
                                <li><a href="<?php echo e(qs_url( qs_filter('date'))); ?>"><span>In this month</span></a></li>
                            <?php endif; ?>

                            <?php if(request()->get('date') == 'last-month'): ?>
                                <li><a href="<?php echo e(qs_url( qs_filter('date'))); ?>"><span>In last month</span></a></li>
                            <?php endif; ?>

                            <?php if(request()->get('date') == '90day'): ?>
                                <li><a href="<?php echo e(qs_url( qs_filter('date'))); ?>"><span>In last 90 days</span></a></li>
                            <?php endif; ?>
                            <li><a href="<?php echo e(route('admin.transactions')); ?>" class="link link-underline">Clear All</a></li>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>

                <?php if($trnxs->total() > 0): ?>
                <table class="data-table admin-tnx">
                    <thead>
                        <tr class="data-item data-head">
                            <th class="data-col tnx-status dt-tnxno">Tranx ID</th>
                            <th class="data-col dt-token">Tokens</th>
                            <th class="data-col dt-amount">Amount</th>
                            <th class="data-col dt-usd-amount">Base Amount</th>
                            <th class="data-col pm-gateway dt-account">Pay From</th>
                            <th class="data-col dt-type tnx-type">Type</th>
                            <th class="data-col"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $trnxs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trnx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $text_danger = ( $trnx->tnx_type=='refund' || ($trnx->tnx_type=='transfer' && $trnx->extra=='sent') ) ? ' text-danger' : '';
                        ?>
                        <tr class="data-item" id="tnx-item-<?php echo e($trnx->id); ?>">
                            <td class="data-col dt-tnxno">
                                <div class="d-flex align-items-center">
                                    <div id="ds-<?php echo e($trnx->id); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo e(__status($trnx->status, 'text')); ?>" class="data-state data-state-<?php echo e(__status($trnx->status, 'icon')); ?>">
                                        <span class="d-none"><?php echo e(ucfirst($trnx->status)); ?></span>
                                    </div>
                                    <div class="fake-class">
                                        <span class="lead tnx-id"><?php echo e($trnx->tnx_id); ?></span>
                                        <span class="sub sub-date"><?php echo e(_date($trnx->tnx_time)); ?></span>
                                    </div>
                                </div>
                            </td>
                            <td class="data-col dt-token">
                                <span class="lead token-amount<?php echo e($text_danger); ?>"><?php echo e((starts_with($trnx->total_tokens, '-') ? '' : '+').to_num($trnx->total_tokens, 'max')); ?></span>
                                <span class="sub sub-symbol"><?php echo e(token('symbol')); ?></span>
                            </td>
                            <td class="data-col dt-amount">
                                <?php if($trnx->tnx_type=='referral'||$trnx->tnx_type=='bonus'): ?>
                                    <span class="lead amount-pay"><?php echo e('~'); ?></span>
                                <?php else: ?>
                                <span class="lead amount-pay<?php echo e($text_danger); ?>"><?php echo e(to_num($trnx->amount, 'max')); ?></span>
                                <span class="sub sub-symbol"><?php echo e(strtoupper($trnx->currency)); ?> <em class="fas fa-info-circle" data-toggle="tooltip" data-placement="bottom" title="1 <?php echo e(token('symbol')); ?> = <?php echo e(to_num($trnx->currency_rate, 'max').' '.strtoupper($trnx->currency)); ?>"></em></span>
                                <?php endif; ?>
                            </td>
                            <td class="data-col dt-usd-amount<?php echo e($text_danger); ?>">
                                <?php if($trnx->tnx_type=='referral'||$trnx->tnx_type=='bonus'): ?>
                                    <span class="lead amount-receive"><?php echo e('~'); ?></span>
                                <?php else: ?>
                                <span class="lead amount-receive<?php echo e($text_danger); ?>"><?php echo e(to_num($trnx->base_amount, 'auto')); ?></span>
                                <span class="sub sub-symbol"><?php echo e(strtoupper($trnx->base_currency)); ?> <em class="fas fa-info-circle" data-toggle="tooltip" data-placement="bottom" title="1 <?php echo e(token('symbol')); ?> = <?php echo e(to_num($trnx->base_currency_rate, 'max').' '.strtoupper($trnx->base_currency)); ?>"></em></span>
                                <?php endif; ?>
                            </td>
                            <td class="data-col dt-account">
                                <span class="sub sub-s2 pay-with">
                                    <?php if($trnx->tnx_type=='bonus' && $trnx->added_by!=set_added_by('0')): ?>
                                        <?php echo e('Added by '.transaction_by($trnx->added_by)); ?>

                                    <?php elseif($trnx->tnx_type == 'refund'): ?>
                                        <?php echo e($trnx->details); ?>

                                    <?php elseif($trnx->tnx_type == 'transfer'): ?>
                                        <?php echo e($trnx->details); ?>

                                    <?php else: ?>
                                        <?php echo e((is_gateway($trnx->payment_method, 'internal') ? gateway_type($trnx->payment_method, 'name') : ( (is_gateway($trnx->payment_method, 'online') || $trnx->payment_method=='bank') ? 'Pay via '.ucfirst($trnx->payment_method) : 'Pay with '.strtoupper($trnx->currency) ) )); ?>

                                        <?php if($trnx->wallet_address && $trnx->tnx_type!='bonus'): ?>
                                        <em class="fas fa-info-circle" data-toggle="tooltip" data-placement="bottom" title="<?php echo e($trnx->wallet_address); ?>"></em>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </span>
                                <?php if($trnx->tnx_type == 'refund'): ?>
                                    <?php
                                    $extra = (is_json($trnx->extra, true) ?? $trnx->extra);
                                    ?>
                                    <span class="sub sub-email"><a href="<?php echo e(route('admin.transactions.view', ($extra->trnx ?? $trnx->id))); ?>"><?php echo e(__("View Transaction")); ?></a></span>
                                <?php else: ?>
                                    <span class="sub sub-email"><?php echo e(set_id($trnx->user)); ?> <em class="fas fa-info-circle" data-toggle="tooltip" data-placement="bottom" title="<?php echo e(isset($trnx->tnxUser) ? explode_user_for_demo($trnx->tnxUser->email, auth()->user()->type) : ''); ?>"></em></span>
                                <?php endif; ?>
                            </td>
                            <td class="data-col data-type">
                                <span class="dt-type-md badge badge-outline badge-md badge-<?php echo e($trnx->id); ?> badge-<?php echo e(__status($trnx->tnx_type,'status')); ?>"><?php echo e(ucfirst($trnx->tnx_type)); ?></span>
                                <span class="dt-type-sm badge badge-sq badge-outline badge-md badge-<?php echo e($trnx->id); ?> badge-<?php echo e(__status($trnx->tnx_type,'status')); ?>"><?php echo e(ucfirst(substr($trnx->tnx_type, 0, 1))); ?></span>
                            </td>
                            <td class="data-col text-right">
                                <?php if($trnx->status == 'deleted'): ?>
                                <a href="<?php echo e(route('admin.transactions.view', $trnx->id)); ?>" target="_blank" class="btn btn-light-alt btn-xs btn-icon"><em class="ti ti-eye"></em></a>
                                <?php else: ?>
                                <div class="relative d-inline-block">
                                    <a href="#" class="btn btn-light-alt btn-xs btn-icon toggle-tigger"><em class="ti ti-more-alt"></em></a>
                                    <div class="toggle-class dropdown-content dropdown-content-top-left">
                                        <ul id="more-menu-<?php echo e($trnx->id); ?>" class="dropdown-list">
                                            <li><a href="<?php echo e(route('admin.transactions.view', $trnx->id)); ?>">
                                                <em class="ti ti-eye"></em> View Details</a></li>
                                            <?php if( $trnx->tnx_type == 'transfer' && $trnx->status == 'pending'): ?>
                                            <li><a href="javascript:void(0)" class="tnx-transfer-action" data-status="approved" data-tnx_id="<?php echo e($trnx->id); ?>">
                                                <em class="far fa-check-square"></em> Approve</a></li>
                                            <li><a href="javascript:void(0)" class="tnx-transfer-action" data-status="rejected" data-tnx_id="<?php echo e($trnx->id); ?>">
                                                <em class="fas fa-ban"></em> Reject</a></li>
                                            <?php endif; ?>
                                            <?php if($trnx->status == 'approved' && $trnx->tnx_type == 'purchase' && $trnx->refund == null): ?>
                                            <li><a href="javascript:void(0)" class="tnx-action" data-type="refund" data-id="<?php echo e($trnx->id); ?>">
                                                <em class="fas fa-reply"></em> Refund</a></li>
                                            <?php endif; ?>
                                            <?php if($trnx->status == 'pending' || $trnx->status == 'onhold'): ?>
                                                <?php if($trnx->payment_method == 'bank' || $trnx->payment_method == 'manual'): ?>
                                                <li><a href="javascript:void(0)" id="adjust_token" data-id="<?php echo e($trnx->id); ?>">
                                                    <em class="far fa-check-square"></em>Approve</a></li>
                                                <?php endif; ?>
                                                <?php if($trnx->payment_method == 'coinbase' && $trnx->status != 'canceled'): ?>
                                                <li><a href="<?php echo e(route('admin.transactions.check', ['tid' => $trnx->id])); ?>">
                                                    <em class="fas fa-reply"></em>Check Status</a></li>
                                                <?php endif; ?>
                                                <?php if($trnx->tnx_type != 'transfer'): ?>
                                                <li id="canceled"><a href="javascript:void(0)" class="tnx-action" data-type="canceled" data-id="<?php echo e($trnx->id); ?>">
                                                    <em class="fas fa-ban"></em>Cancel</a></li>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if($trnx->status == 'canceled'): ?>
                                                <?php if( !empty($trnx->checked_by) && ($trnx->payment_method == 'bank' || $trnx->payment_method == 'manual')): ?>
                                                <li><a href="javascript:void(0)" id="adjust_token" data-id="<?php echo e($trnx->id); ?>">
                                                    <em class="far fa-check-square"></em>Approve</a></li>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php else: ?>
                    <div class="bg-light text-center rounded pdt-5x pdb-5x">
                        <p><em class="ti ti-server fs-24"></em><br><?php echo e(($is_page=='all') ? 'No transaction found!' : 'No '.$is_page.' transaction here!'); ?></p>
                        <p><a class="btn btn-primary btn-auto" href="<?php echo e(route('admin.transactions')); ?>">View All Transactions</a></p>
                    </div>
                <?php endif; ?>

                <?php if($pagi->hasPages()): ?>
                <div class="pagination-bar">
                    <div class="d-flex flex-wrap justify-content-between guttar-vr-20px guttar-20px">
                        <div class="fake-class">
                            <ul class="btn-grp guttar-10px pagination-btn">
                                <?php if($pagi->previousPageUrl()): ?>
                                <li><a href="<?php echo e($pagi->previousPageUrl()); ?>" class="btn ucap btn-auto btn-sm btn-light-alt">Prev</a></li>
                                <?php endif; ?>
                                <?php if($pagi->nextPageUrl()): ?>
                                <li><a href="<?php echo e($pagi->nextPageUrl()); ?>" class="btn ucap btn-auto btn-sm btn-light-alt">Next</a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="fake-class">
                            <div class="pagination-info guttar-10px justify-content-sm-end justify-content-mb-end">
                                <div class="pagination-info-text ucap">Page </div>
                                <div class="input-wrap w-80px">
                                    <select class="select select-xs select-bordered goto-page" data-dd-class="search-<?php echo e(($pagi->lastPage() > 7) ? 'on' : 'off'); ?>">
                                        <?php for($i = 1; $i <= $pagi->lastPage(); $i++): ?>
                                        <option value="<?php echo e($pagi->url($i)); ?>"<?php echo e(($pagi->currentPage() ==$i) ? ' selected' : ''); ?>><?php echo e($i); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            <div class="pagination-info-text ucap">of <?php echo e($pagi->lastPage()); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer'); ?>
    <script>
        $(document).ready(function () {
            var $addTnx = $('.addTnx'), $ajax_modal = $('#ajax-modal');

            $addTnx.on('click', function () {
                $.get("<?php echo e(route('admin.ajax.transactions.create')); ?>")
                .done(response => {
                    $ajax_modal.html(response);
                    init_inside_modal();
                    $ajax_modal.children('.modal').modal('show');
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/admin/transactions.blade.php ENDPATH**/ ?>