<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="js">
<head>
    <meta charset="utf-8">
    <meta name="apps" content="<?php echo e(site_whitelabel('apps')); ?>">
    <meta name="author" content="<?php echo e(site_whitelabel('author')); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="site-token" content="<?php echo e(site_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(site_favicon()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(site_whitelabel('title')); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset(style_theme('vendor'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(style_theme('user'))); ?>">
    <?php if( recaptcha() ): ?>
    <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(recaptcha('site')); ?>"></script>
    <?php endif; ?>
    <?php echo $__env->yieldPushContent('header'); ?>
<?php if(get_setting('site_header_code', false)): ?>
    <?php echo e(html_string(get_setting('site_header_code'))); ?>

<?php endif; ?>
</head>

<body class="user-dashboard page-user theme-modern">
    <div class="topbar-wrap">
        <div class="topbar is-sticky">
            <div class="container">
                <div class="d-flex justify-content-center">
                    <a class="topbar-logo" href="<?php echo e(url('/')); ?>">
                        <img height="40" src="<?php echo e(site_logo('default', 'light')); ?>" srcset="<?php echo e(site_logo('retina', 'light' )); ?>" alt="<?php echo e(site_info()); ?>">
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="page-content">
        <div class="container">
            <?php echo $__env->yieldContent('content'); ?> 
        </div>
    </div>

    <div class="footer-bar">
        <div class="container">
            <?php if(is_show_social('site')): ?>
            <div class="row justify-content-center">
                <div class="col-lg-5 text-center order-lg-last text-lg-right pdb-2x pb-lg-0">
                    <?php echo UserPanel::social_links(); ?>

                </div>
                <div class="col-lg-7">
                    <div class="d-flex align-items-center justify-content-center justify-content-lg-start guttar-15px pdb-1-5x pb-lg-2">
                        <div class="copyright-text"><?php echo UserPanel::copyrights(); ?></div>
                        <?php echo UserPanel::language_switcher(); ?>

                    </div>
                    <?php echo UserPanel::footer_links(null, ['class'=>'align-items-center justify-content-center justify-content-lg-start']); ?>

                </div>
            </div>
            <?php else: ?> 
            <div class="row align-items-center justify-content-center">
                <div class="col-lg-7">
                    <?php echo UserPanel::footer_links(null, ['class'=>'guttar-20px']); ?>

                </div>
                <div class="col-lg-5 mt-2 mt-sm-0">
                    <div class="d-flex justify-content-between justify-content-lg-end align-items-center guttar-15px">
                        <div class="copyright-text"><?php echo UserPanel::copyrights(); ?></div>
                        <?php echo UserPanel::language_switcher(); ?>

                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <?php echo $__env->yieldContent('modals'); ?>
    <div id="ajax-modal"></div>
    <div class="page-overlay">
        <div class="spinner"><span class="sp sp1"></span><span class="sp sp2"></span><span class="sp sp3"></span></div>
    </div>
<script src="<?php echo e(asset('assets/js/jquery.bundle.js').css_js_ver()); ?>"></script>
<script src="<?php echo e(asset('assets/js/script.js').css_js_ver()); ?>"></script>
<?php echo $__env->yieldPushContent('footer'); ?>
    <script type="text/javascript">
        var base_url = "<?php echo e(url('/')); ?>",
        csrf_token = document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
        user_wallet_address = "<?php echo e(route('user.ajax.account.wallet')); ?>",
        layouts_style = "modern";

        <?php if(session('resent')): ?>
        show_toast("success","<?php echo e(__('A fresh verification link has been sent to your email address.')); ?>");
        <?php endif; ?>
    </script>
    <?php if(get_setting('site_footer_code', false)): ?>
    <?php echo e(html_string(get_setting('site_footer_code'))); ?>

    <?php endif; ?>
</body>
</html><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/public/base.blade.php ENDPATH**/ ?>