
<?php $__env->startSection('title', ucfirst($is_page).' KYC Application'); ?>


<?php $__env->startSection('content'); ?>

<div class="page-content">
    <div class="container">
        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('vendor.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="card content-area content-area-mh">
            <div class="card-innr">
                <div class="card-head has-aside">
                    <h4 class="card-title"><?php echo e(ucfirst($is_page)); ?> KYC Application</h4>
                    <div class="card-opt">
                        <ul class="btn-grp btn-grp-block guttar-20px">
                            <li>
                                <a href="javascript:void(0)" data-type="kyc_settings" class="btn btn-auto btn-sm btn-primary get_kyc">
                                    <em class="ti ti-settings"></em><span>KYC <span class="d-none d-md-inline-block">Form</span> Settings</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="page-nav-wrap">
                    <div class="page-nav-bar justify-content-between bg-lighter">
                        <div class="page-nav w-100 w-lg-auto">
                            <ul class="nav">
                                <li class="nav-item<?php echo e((is_page('kyc-list.pending') ? ' active' : '')); ?>"><a class="nav-link" href="<?php echo e(route('admin.kycs', 'pending')); ?>">Pending</a></li>

                                <li class="nav-item<?php echo e((is_page('kyc-list.missing') ? ' active' : '')); ?>"><a class="nav-link" href="<?php echo e(route('admin.kycs', 'missing')); ?>">Missing</a></li>

                                <li class="nav-item<?php echo e((is_page('kyc-list.approved') ? ' active' : '')); ?>"><a class="nav-link" href="<?php echo e(route('admin.kycs', 'approved')); ?>">Approved</a></li>

                                <li class="nav-item<?php echo e((is_page('kyc-list') ? ' active' : '')); ?>"><a class="nav-link" href="<?php echo e(route('admin.kycs')); ?>">All</a></li>
                            </ul>
                        </div>
                        <div class="search flex-grow-1 pl-lg-4 w-100 w-sm-auto">
                            <form action="<?php echo e(route('admin.kycs')); ?>" method="GET" autocomplete="off">
                                <div class="input-wrap">
                                    <span class="input-icon input-icon-left"><em class="ti ti-search"></em></span>
                                    <input type="search" class="input-solid input-transparent" placeholder="Quick search with name/id" value="<?php echo e(request()->get('s', '')); ?>" name="s">
                                </div>
                            </form>
                        </div>
                        <?php if(!empty(env_file()) && nio_status() && !empty(app_key())): ?>
                        <div class="tools w-100 w-sm-auto">
                            <ul class="btn-grp guttar-8px">
                                <li><a href="#" class="btn btn-light btn-sm btn-icon btn-outline bg-white advsearch-opt"> <em class="ti ti-panel"></em> </a></li>
                                <li>
                                    <div class="relative">
                                        <a href="#" class="btn btn-light bg-white btn-sm btn-icon toggle-tigger btn-outline"><em class="ti ti-server"></em> </a>
                                        <div class="toggle-class dropdown-content dropdown-content-sm dropdown-content-center shadow-soft">
                                            <ul class="dropdown-list">
                                                <li><h6 class="dropdown-title">Export</h6></li>
                                                <li><a href="<?php echo e(route('admin.export', array_merge([ 'table' => 'kycs', 'format' => 'entire'], request()->all()))); ?>">Entire</a></li>
                                                <li><a href="<?php echo e(route('admin.export', array_merge([ 'table' => 'kycs', 'format' => 'minimal'], request()->all()))); ?>">Minimal</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </li>
                                <li>
                                    <div class="relative">
                                        <a href="#" class="btn btn-light bg-white btn-sm btn-icon toggle-tigger btn-outline"><em class="ti ti-settings"></em> </a>
                                        <div class="toggle-class dropdown-content dropdown-content-sm dropdown-content-center shadow-soft">
                                            <form class="update-meta" action="#" data-type="kyc_page_meta">
                                                <ul class="dropdown-list">
                                                    <li><h6 class="dropdown-title">Show</h6></li>
                                                    <li<?php echo (gmvl('kyc_per_page', 10)==10) ? ' class="active"' : ''; ?>>
                                                        <a href="#" data-meta="perpage=10">10</a></li>
                                                    <li<?php echo (gmvl('kyc_per_page', 10)==20) ? ' class="active"' : ''; ?>>
                                                        <a href="#" data-meta="perpage=20">20</a></li>
                                                    <li<?php echo (gmvl('kyc_per_page', 10)==50) ? ' class="active"' : ''; ?>>
                                                        <a href="#" data-meta="perpage=50">50</a></li>
                                                </ul>
                                                <ul class="dropdown-list">
                                                    <li><h6 class="dropdown-title">Order</h6></li>
                                                    <li<?php echo (gmvl('kyc_ordered', 'DESC')=='DESC') ? ' class="active"' : ''; ?>>
                                                        <a href="#" data-meta="ordered=DESC">DESC</a></li>
                                                    <li<?php echo (gmvl('kyc_ordered', 'DESC')=='ASC') ? ' class="active"' : ''; ?>>
                                                        <a href="#" data-meta="ordered=ASC">ASC</a></li>
                                                </ul>
                                            </form>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php if(!empty(env_file()) && nio_status() && !empty(app_key())): ?>
                    <div class="search-adv-wrap hide">
                        <form class="adv-search" id="adv-search" action="<?php echo e(route('admin.kycs')); ?>" method="GET" autocomplete="off">
                            <div class="adv-search">
                                <div class="row align-items-end guttar-20px guttar-vr-15px">
                                    <div class="col-lg-6">
                                       <div class="input-grp-wrap">
                                            <span class="input-item-label input-item-label-s2 text-exlight">Advanced Search</span>
                                            <div class="input-grp align-items-center bg-white">
                                                <div class="input-wrap flex-grow-1">
                                                    <input value="<?php echo e(request()->get('search')); ?>" class="input-solid input-solid-sm input-transparent" type="text" placeholder="Search by name/id" name="search">
                                                </div>
                                                <ul class="search-type">
                                                    <li class="input-wrap input-radio-wrap">
                                                        <input name="by" class="input-radio-select" id="advs-by-uid" value="" type="radio"<?php echo e((empty(request()->by) || request()->by!='name') ? ' checked' : ''); ?>>
                                                        <label for="advs-by-uid">UID</label>
                                                    </li>
                                                    <li class="input-wrap input-radio-wrap">
                                                        <input name="by" class="input-radio-select" id="advs-by-name" value="name" type="radio"<?php echo e((isset(request()->by) && request()->by=='name') ? ' checked' : ''); ?>>
                                                        <label for="advs-by-name">Name</label>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4 col-lg-2 col-mb-6">
                                        <div class="input-wrap input-with-label">
                                            <label class="input-item-label input-item-label-s2 text-exlight">Status</label>
                                            <select name="state" class="select select-sm select-block select-bordered" data-dd-class="search-off">
                                                <option value="">Any Status</option>
                                                <option<?php echo e(request()->get('state') == 'pending' ? ' selected' : ''); ?> value="pending">Pending</option>
                                                <option<?php echo e(request()->get('state') == 'missing' ? ' selected' : ''); ?> value="missing">Missing</option>
                                                <option<?php echo e(request()->get('state') == 'approved' ? ' selected' : ''); ?> value="approved">Approved</option>
                                                <option<?php echo e(request()->get('state') == 'deleted' ? ' selected' : ''); ?> value="deleted">Deleted</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-4 col-lg-2 col-mb-6">
                                        <div class="input-wrap input-with-label">
                                            <label class="input-item-label input-item-label-s2 text-exlight">DOC TYPE</label>
                                            <select name="doc" class="select select-sm select-block select-bordered" data-dd-class="search-off">
                                                <option value="">Any Type</option>
                                                <option<?php echo e(request()->get('doc') == 'nidcard' ? ' selected' : ''); ?> value="nidcard">Nidcard</option>
                                                <option<?php echo e(request()->get('doc') == 'passport' ? ' selected' : ''); ?> value="passport">Passport</option>
                                                <option<?php echo e(request()->get('doc') == 'driving' ? ' selected' : ''); ?> value="driving">Driving</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-4 col-lg-2 col-mb-6">
                                        <div class="input-wrap">
                                            <input type="hidden" name="filter" value="1">
                                            <button class="btn btn-sm btn-sm-s2 btn-auto btn-primary">
                                                <em class="ti ti-search width-auto"></em><span>Search</span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <?php endif; ?>
                    <?php if(request()->get('filter') || request()->s): ?>
                    <div class="search-adv-result">
                        <div class="search-info">Found <span class="search-count"><?php echo e($kycs->total()); ?></span> Applications.</div>
                        <ul class="search-opt">
                            <?php if(request()->get('search')): ?>
                                <li><a href="<?php echo e(qs_url(qs_filter('search'))); ?>">Search <span>'<?php echo e(request()->get('search')); ?>'</span><?php echo e((!empty(request()->by)) ? ' ('.ucfirst(request()->by).')' : ''); ?></a></li>
                            <?php endif; ?>
                            <?php if(request()->get('state')): ?>
                                <li><a href="<?php echo e(qs_url(qs_filter('state'))); ?>">Status: <span><?php echo e(ucfirst(request()->get('state'))); ?></span></a></li>
                            <?php endif; ?>
                            <?php if(request()->get('doc')): ?>
                                <li><a href="<?php echo e(qs_url(qs_filter('doc'))); ?>">DOC Type: <span><?php echo e(ucfirst(request()->get('doc'))); ?></span></a></li>
                            <?php endif; ?>
                            <li><a href="<?php echo e(route('admin.kycs')); ?>" class="link link-underline">Clear All</a></li>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
                
                <?php if($kycs->total() > 0): ?> 
                <table class="data-table kyc-list">
                    <thead>
                        <tr class="data-item data-head">
                            <th class="data-col filter-data dt-user">User</th>
                            <th class="data-col dt-doc-type">Doc Type</th>
                            <th class="data-col dt-doc-front">Documents</th>
                            <th class="data-col dt-doc-back">&nbsp;</th>
                            <th class="data-col dt-doc-proof">&nbsp;</th>
                            <th class="data-col dt-sbdate">Submitted</th>
                            <th class="data-col dt-status">Status</th>
                            <th class="data-col"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $kycs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kyc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="data-item data-item-<?php echo e($kyc->id); ?>">
                            <td class="data-col dt-user">
                                <span class="d-none"><?php echo e($kyc->status); ?></span>
                                <span class="lead user-name"><?php echo e(_x($kyc->firstName).' '._x($kyc->lastName)); ?></span>
                                <span class="sub user-id"><?php echo e(set_id($kyc->userId)); ?></span>
                            </td>
                            <td class="data-col dt-doc-type">
                                <span class="sub sub-s2 sub-dtype"><?php echo e(ucfirst($kyc->documentType)); ?></span>
                            </td>
                            
                            <td class="data-col dt-docs dt-doc-front">
                                <?php if($kyc->document != NULL): ?>
                                    <?php if(pathinfo(storage_path('app/'.$kyc->document), PATHINFO_EXTENSION) != 'pdf'): ?>
                                        <a href="<?php echo e(route('admin.kycs.file', ['file'=>$kyc->id, 'doc'=>1])); ?>" class="image-popup"><?php echo e(($kyc->documentType == 'nidcard') ? 'Front Side' : 'Document'); ?></a>
                                    <?php else: ?> 
                                        <?php echo ($kyc->documentType == 'nidcard') ? '<a>Front Side</a>' : '<a>Document</a>'; ?>

                                    <?php endif; ?>
                                    &nbsp; <a title="Download" href="<?php echo e(route('admin.kycs.file', ['file'=>$kyc->id, 'doc'=>1])); ?>" target="_blank"><em class="fas fa-download"></em></a>
                                <?php else: ?> 
                                &nbsp;
                                <?php endif; ?>
                            </td>
                            <td class="data-col dt-docs dt-doc-back">
                                <?php if($kyc->document2 != NULL): ?>
                                    <?php if(pathinfo(storage_path('app/'.$kyc->document2), PATHINFO_EXTENSION) != 'pdf'): ?>
                                        <a href="<?php echo e(route('admin.kycs.file', ['file'=>$kyc->id, 'doc'=>2])); ?>" class="image-popup"><?php echo e(($kyc->documentType == 'nidcard') ? 'Back Side' : 'Proof'); ?></a>
                                    <?php else: ?> 
                                        <?php echo ($kyc->documentType == 'nidcard') ? '<a>Back Side</a>' : '<a>Proof</a>'; ?>

                                    <?php endif; ?>
                                    &nbsp; <a title="Download" href="<?php echo e(route('admin.kycs.file', ['file'=>$kyc->id, 'doc'=>2])); ?>" target="_blank"><em class="fas fa-download"></em></a>
                                <?php else: ?> 
                                &nbsp;
                                <?php endif; ?>
                            </td>
                            <td class="data-col dt-docs dt-doc-proof">
                                <?php if($kyc->document3 != NULL): ?>
                                    <?php if(pathinfo(storage_path('app/'.$kyc->document3), PATHINFO_EXTENSION) != 'pdf'): ?>
                                        <a href="<?php echo e(route('admin.kycs.file', ['file'=>$kyc->id, 'doc'=>3])); ?>" class="image-popup">Proof</a>
                                    <?php else: ?> 
                                        <a>Proof</a>
                                    <?php endif; ?>
                                    &nbsp; <a title="Download" href="<?php echo e(route('admin.kycs.file', ['file'=>$kyc->id, 'doc'=>3])); ?>" target="_blank"><em class="fas fa-download"></em></a>
                                <?php else: ?> 
                                &nbsp;
                                <?php endif; ?>
                            </td>
                            <td class="data-col dt-sbdate">
                                <span class="sub sub-s2 sub-time"><?php echo e(_date($kyc->created_at)); ?></span>
                            </td>
                            <td class="data-col dt-status">
                                <span class="dt-status-md badge badge-outline badge-md badge-<?php echo e(__status($kyc->status,'status')); ?>"><?php echo e(__status($kyc->status,'text')); ?></span>
                                <span class="dt-status-sm badge badge-sq badge-outline badge-md badge-<?php echo e(__status($kyc->status,'status')); ?>"><?php echo e(substr(__status($kyc->status,'text'), 0, 1)); ?></span>
                            </td>
                            <td class="data-col text-right">
                                <div class="relative d-inline-block">
                                    <a href="#" class="btn btn-light-alt btn-xs btn-icon toggle-tigger"><em class="ti ti-more-alt"></em></a>
                                    <div class="toggle-class dropdown-content dropdown-content-top-left">
                                        <ul class="dropdown-list more-menu more-menu-<?php echo e($kyc->id); ?>">
                                            <li><a href="<?php echo e(route('admin.kyc.view', [$kyc->id, 'kyc_details' ])); ?>"><em class="ti ti-eye"></em> View Details</a></li>
                                            <?php if($kyc->status != 'approved'): ?>
                                            <li><a class="kyc_action kyc_approve" href="#" data-id="<?php echo e($kyc->id); ?>" data-toggle="modal" data-target="#actionkyc"><em class="far fa-check-square"></em>Approve</a></li>
                                            <?php endif; ?>
                                            <?php if($kyc->status != 'rejected'): ?>
                                            <li><a href="javascript:void(0)" data-current="<?php echo e(__status($kyc->status,'status')); ?>" data-id="<?php echo e($kyc->id); ?>" class="kyc_reject"><em class="fas fa-ban"></em>Reject</a></li>
                                            <?php endif; ?>
                                            <?php if($kyc->status == 'missing' || $kyc->status == 'rejected'): ?>
                                            <li><a href="javascript:void(0)" data-id="<?php echo e($kyc->id); ?>" class="kyc_delete"><em class="fas fa-trash-alt"></em>Delete</a></li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php else: ?> 
                    <div class="bg-light text-center rounded pdt-5x pdb-5x">
                        <p><em class="ti ti-server fs-24"></em><br><?php echo e(($is_page=='all') ? 'No KYC application found!' : 'No '.$is_page.' KYC application here!'); ?></p>
                        <p><a class="btn btn-primary btn-auto" href="<?php echo e(route('admin.kycs')); ?>">View All KYC Application</a></p>
                    </div>
                <?php endif; ?>

                <?php if($pagi->hasPages()): ?>
                <div class="pagination-bar">
                    <div class="d-flex flex-wrap justify-content-between guttar-vr-20px guttar-20px">
                        <div class="fake-class">
                            <ul class="btn-grp guttar-10px pagination-btn">
                                <?php if($pagi->previousPageUrl()): ?>
                                <li><a href="<?php echo e($pagi->previousPageUrl()); ?>" class="btn ucap btn-auto btn-sm btn-light-alt">Prev</a></li>
                                <?php endif; ?> 
                                <?php if($pagi->nextPageUrl()): ?>
                                <li><a href="<?php echo e($pagi->nextPageUrl()); ?>" class="btn ucap btn-auto btn-sm btn-light-alt">Next</a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="fake-class">
                            <div class="pagination-info guttar-10px justify-content-sm-end justify-content-mb-end">
                                <div class="pagination-info-text ucap">Page </div>
                                <div class="input-wrap w-80px">
                                    <select class="select select-xs select-bordered goto-page" data-dd-class="search-<?php echo e(($pagi->lastPage() > 7) ? 'on' : 'off'); ?>">
                                        <?php for($i = 1; $i <= $pagi->lastPage(); $i++): ?>
                                        <option value="<?php echo e($pagi->url($i)); ?>"<?php echo e(($pagi->currentPage() ==$i) ? ' selected' : ''); ?>><?php echo e($i); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            <div class="pagination-info-text ucap">of <?php echo e($pagi->lastPage()); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modals'); ?>

<div class="modal fade" id="actionkyc" tabindex="-1">
    <div class="modal-dialog modal-dialog-md modal-dialog-centered">
        <div class="modal-content">
            <a href="#" class="modal-close" data-dismiss="modal"><em class="ti ti-close"></em></a>
            <div class="popup-body popup-body-md">
                <h3 class="popup-title">Approve the KYC Information</h3>
                <p>Please check details carefully of the application before take any action. User can not re-submit the application if you invalidated this application.</p>
                <form action="<?php echo e(route('admin.ajax.kyc.update')); ?>" method="POST" id="kyc_status_form">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="req_type" value="update_kyc_status">
                    <input type="hidden" name="kyc_id" id="kyc_id" required="required">
                    <div class="input-item input-with-label">
                        <label class="input-item-label">Admin Note</label>
                        <textarea name="notes" class="input-bordered input-textarea input-textarea-sm"></textarea>
                    </div>
                    <div class="input-item">
                        <input class="input-checkbox" id="send-email" checked type="checkbox">
                        <label for="send-email">Send Notification to Applicant</label>
                    </div>
                    <div class="gaps-1x"></div>
                    <ul class="btn-grp guttar-20px">
                        <li><button name="status" data-value="approved" class="update_kyc form-progress-btn btn btn-md btn-primary ucap">Approve</button></li>
                        <li><button name="status" data-value="missing" class="update_kyc form-progress-btn btn btn-md btn-light ucap">Missing</button></li>
                        <li><button name="status" data-value="rejected" class="update_kyc form-progress-btn btn btn-md btn-danger ucap">Reject</button></li>
                    </ul>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/admin/kycs.blade.php ENDPATH**/ ?>