
<?php $__env->startSection('title', 'ICO/STO Setting'); ?>
<?php
$wallet_opt = field_value_text('token_wallet_opt' , 'wallet_opt');
is_array($wallet_opt) ? true : $wallet_opt = array();
$custom = field_value_text('token_wallet_custom');
is_array($custom) ? true : $custom = array();
?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
    <div class="container">
        <div class="row">
            <div class="main-content col-lg-12">
                <?php echo $__env->make('vendor.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="content-area card">
                    <div class="card-innr">
                        <div class="card-head">
                            <h4 class="card-title">ICO/STO Settings </h4>
                        </div>
                        <div class="gaps-1x"></div>
                        <div class="card-text ico-setting setting-token-details">
                            <h3 class="card-title-md text-primary">ICO/STO Token Details</h3>
                            <form action="<?php echo e(route('admin.ajax.stages.settings.update')); ?>" method="POST" id="stage_setting_details_form" class="validate-modern">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="req_type" value="token_details">
                                <div class="row">
                                    <div class="col-xl-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Token Name</label>
                                            <div class="input-wrap">
                                                <input class="input-bordered" required type="text" name="token_name" value="<?php echo e(token('name')); ?>" minlength="3">
                                            </div>
                                            <span class="input-note">Enter name of token without spaces. Lower and uppercase can be used.</span>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Token Symbol</label>
                                            <div class="input-wrap">
                                                <input class="input-bordered" required type="text" name="token_symbol" value="<?php echo e(token('symbol')); ?>" minlength="2">
                                            </div>
                                            <span class="input-note">Usually 3-4 Letters like ETH, BTC, WISH etc.</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xl-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Decimal Minimum</label>
                                            <div class="input-wrap">
                                                <input class="input-bordered" type="number" name="token_decimal_min" value="<?php echo e(token('decimal_min')); ?>" min="2" max="8">
                                            </div>
                                            <span class="input-note">Minimum number of decimal point for calculation. 2-8 are accepted.</span>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Decimal Maximum</label>
                                            <div class="input-wrap">
                                                <input class="input-bordered" type="number" name="token_decimal_max" value="<?php echo e(token('decimal_max')); ?>" min="6" max="18">
                                            </div>
                                            <span class="input-note">Maximum number of decimal point for calculation. 6-18 are accepted.</span>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Decimal Display</label>
                                            <div class="input-wrap">
                                                <input class="input-bordered" type="number" name="token_decimal_show" value="<?php echo e(token('decimal_show') ? token('decimal_show') : 0); ?>" min="0" max="8">
                                            </div>
                                            <span class="input-note">The number of decimal point apply to show number in User/Admin Card balance.</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="gaps-1x"></div>
                                <div class="d-flex">
                                    <button class="btn btn-primary save-disabled" type="submit" disabled><i class="ti ti-reload"></i><span>Update</span></button>
                                </div>
                            </form>
                        </div>
                        <div class="sap sap-gap"></div>
                        <div class="card-text ico-setting setting-token-purchase">
                            <h4 class="card-title-md text-primary">Purchase & Addtional Setting</h4>
                            <form action="<?php echo e(route('admin.ajax.stages.settings.update')); ?>" method="POST" id="stage_setting_purchase_form" class="validate-modern">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="req_type" value="token_purchase">
                                <div class="row">
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Default Selection</label>
                                            <div class="input-wrap">
                                                <select class="select select-block select-bordered active_method" name="token_default_method">
                                                    <?php $__currentLoopData = $pm_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pmg => $pmval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(get_setting('pmc_active_'.$pmg) == 1): ?>
                                                    <option <?php echo e(token('default_method') == strtoupper($pmg) ? 'selected ' : ''); ?>value="<?php echo e(strtoupper($pmg)); ?>"><?php echo e($pmval.(($pmg==base_currency()) ? ' (Based)' : '')); ?></option>
                                                    <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Token Price Show in</label>
                                            <div class="input-wrap">
                                                <select class="select select-block select-bordered" name="token_default_in_userpanel">
                                                    <?php $__currentLoopData = $pm_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pmg => $pmval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(get_setting('pmc_active_'.$pmg) == 1 && base_currency() != $pmg): ?>
                                                    <option <?php echo e(token('default_in_userpanel') == strtoupper($pmg) ? 'selected ' : ''); ?>value="<?php echo e(strtoupper($pmg)); ?>"> <?php echo e(base_currency(true)); ?> -> <?php echo e(strtoupper($pmg)); ?></option>
                                                    <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Per Token Price</label>
                                            <div class="input-wrap input-wrap-switch">
                                                <input class="input-switch" name="token_price_show" type="checkbox" <?php echo e(token('price_show') == 1 ? 'checked' : ''); ?> id="per-token-price">
                                                <label for="per-token-price">Show</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Amount in Money Format</label>
                                            <div class="input-wrap input-wrap-switch">
                                                <input class="input-switch" name="token_number_format" type="checkbox" <?php echo e(token('number_format') == 1 ? 'checked' : ''); ?> id="format-number">
                                                <label for="format-number">Enabled</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">KYC Before Purchase</label>
                                            <div class="input-wrap input-wrap-switch">
                                                <input class="input-switch" name="token_before_kyc" type="checkbox" <?php echo e(token('before_kyc') == 1 ? 'checked' : ''); ?> id="kyc-before-buy">
                                                <label for="kyc-before-buy">Enable</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <label class="input-item-label">Purchase With</label>
                                        <ul class="d-flex flex-wrap checkbox-list checkbox-list-c5">
                                            <?php $__currentLoopData = $pm_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pmg => $pmval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(get_setting('pmc_active_'.$pmg) == 1): ?>
                                            <li>
                                                <div class="input-item text-left">
                                                    <div class="input-wrap">
                                                        <input class="input-checkbox input-checkbox-sm all_methods" name="token_purchase_<?php echo e($pmg); ?>" id="pw-<?php echo e($pmg); ?>" <?php echo e((token('purchase_'.$pmg) == 1) ? 'checked ' : ' '); ?> <?php echo e(token('default_method') == strtoupper($pmg) ? 'disabled ' : ' '); ?>  type="checkbox">
                                                        <label for="pw-<?php echo e($pmg); ?>"><?php echo e($pmval .' ('.strtoupper($pmg).')'); ?></label>
                                                    </div>
                                                </div>
                                            </li>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                                <div class="gaps-2x"></div>
                                <h5 class="card-title-sm text-secondary">Progress Bar Setting</h5>
                                <div class="row">
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Raised Amount Show in</label>
                                            <div class="input-wrap">
                                                <select class="select select-block select-bordered" name="token_sales_raised">
                                                    <option <?php echo e(token('sales_raised') == 'token' ? 'selected ' : ''); ?>value="token">Token Amount</option>
                                                    <?php $__currentLoopData = $pm_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pmg => $pmval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(get_setting('pmc_active_'.$pmg) == 1): ?>
                                                    <option <?php echo e(token('sales_raised') == $pmg ? 'selected ' : ''); ?>value="<?php echo e($pmg); ?>"><?php echo e($pmval.(($pmg==base_currency()) ? ' (Based)' : '')); ?></option>
                                                    <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Total Amount Show in</label>
                                            <div class="input-wrap">
                                                <select class="select select-block select-bordered" name="token_sales_total">
                                                    <option <?php echo e(token('sales_total') == 'token' ? 'selected ' : ''); ?>value="token">Token Amount</option>
                                                    <?php $__currentLoopData = $pm_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pmg => $pmval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(get_setting('pmc_active_'.$pmg) == 1): ?>
                                                    <option <?php echo e(token('sales_total') == $pmg ? 'selected ' : ''); ?>value="<?php echo e($pmg); ?>"><?php echo e($pmval.(($pmg==base_currency()) ? ' (Based)' : '')); ?></option>
                                                    <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Soft/HardCap Show in</label>
                                            <div class="input-wrap">
                                                <select class="select select-block select-bordered" name="token_sales_cap">
                                                    <option <?php echo e(token('sales_cap') == 'token' ? 'selected ' : ''); ?>value="token">Token Amount</option>
                                                    <?php $__currentLoopData = $pm_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pmg => $pmval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(get_setting('pmc_active_'.$pmg) == 1): ?>
                                                    <option <?php echo e(token('sales_cap') == $pmg ? 'selected ' : ''); ?>value="<?php echo e($pmg); ?>"><?php echo e($pmval.(($pmg==base_currency()) ? ' (Based)' : '')); ?></option>
                                                    <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="gaps-1x"></div>
                                <div class="d-flex">
                                    <button class="btn btn-primary save-disabled" type="submit" disabled><i class="ti ti-reload"></i><span>Update</span></button>
                                </div>
                            </form>
                        </div>
                        <div class="sap sap-gap"></div>
                        <div class="card-text ico-setting setting-ico-userpanel">
                            <h4 class="card-title-md text-primary">User Panel Settings</h4>
                            <p>Manage your User/Investor panel setting for your application.</p>
                            <div class="gaps-1x"></div>
                            <form action="<?php echo e(route('admin.ajax.stages.settings.update')); ?>" method="POST" id="upanel_setting_form" class="validate-modern">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="req_type" value="user_panel">
                                <h5 class="card-title-sm text-secondary">User Dashboard</h5>
                                <div class="row">
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Token Sales Progress</label>
                                            <div class="input-wrap input-wrap-switch">
                                                <input class="input-switch" name="user_sales_progress" type="checkbox" <?php echo e(gws('user_sales_progress', 1) == 1 ? 'checked' : ''); ?> id="sales-progress-hide">
                                                <label for="sales-progress-hide">Show</label>
                                            </div>
                                            <span class="input-note">Whether show or hide the <strong>'Token Sales Progress'</strong> in User Panel.</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Countdown in Sales Progress</label>
                                            <div class="input-wrap input-wrap-switch">
                                                <input class="input-switch" name="opt_count_hide" type="checkbox" <?php echo e(gws('opt_count_hide', 0) == 1 ? 'checked' : ''); ?> id="user-opt-hide">
                                                <label for="user-opt-hide">Hide</label>
                                            </div>
                                            <span class="input-note">Whether hide or show the <strong>token sales countdown options</strong> in User Panel.</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Hide Welcome Block Image</label>
                                            <div class="input-wrap input-wrap-switch">
                                                <input class="input-switch" name="welcome_img_hide" type="checkbox" <?php echo e(gws('welcome_img_hide') == 1 ? 'checked' : ''); ?> id="welcome-img-hide">
                                                <label for="welcome-img-hide">Hide</label>
                                            </div>
                                            <span class="input-note">Whether hide or show the <strong>Image</strong> from 'Welcome block' in User Panel.</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Hide KYC Application</label>
                                            <div class="input-wrap input-wrap-switch">
                                                <input class="input-switch" name="kyc_opt_hide" type="checkbox" <?php echo e(gws('kyc_opt_hide') == 1 ? 'checked' : ''); ?> id="user-kyc-hide">
                                                <label for="user-kyc-hide">Hide</label>
                                            </div>
                                            <span class="input-note">Whether hide or show the <strong>'KYC Application'</strong> in User Panel.</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Display Contribution In</label>
                                            <div class="row guttar-15px">
                                                <div class="col-6">
                                                    <div class="input-wrap">
                                                        <select class="select select-block select-bordered" name="user_in_cur1">
                                                            <?php $__currentLoopData = $pm_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cur => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(get_setting('pmc_active_'.$cur) == 1 && $cur!=base_currency()): ?>
                                                            <option <?php echo e(gws('user_in_cur1') == $cur ? 'selected ' : ''); ?>value="<?php echo e($cur); ?>"><?php echo e(strtoupper($cur)); ?></option>
                                                            <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php echo e(gws('user_in_cur1') == 'hide' ? 'selected ' : ''); ?>value="hide">Hide</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="input-wrap">
                                                        <select class="select select-block select-bordered" name="user_in_cur2">
                                                            <?php $__currentLoopData = $pm_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cur => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(get_setting('pmc_active_'.$cur) == 1 && $cur!=base_currency()): ?>
                                                            <option <?php echo e(gws('user_in_cur2') == $cur ? 'selected ' : ''); ?>value="<?php echo e($cur); ?>"><?php echo e(strtoupper($cur)); ?></option>
                                                            <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php echo e(gws('user_in_cur2') == 'hide' ? 'selected ' : ''); ?>value="hide">Hide</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <span class="input-note">Select two currencies which will show on balance card for <strong>'Contribution in'</strong>.</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">My Token Page</label>
                                            <div class="input-wrap input-wrap-switch">
                                                <input class="input-switch" name="user_mytoken_page" type="checkbox" <?php echo e(gws('user_mytoken_page') == 1 ? 'checked' : ''); ?> id="show-mytoken-page">
                                                <label for="show-mytoken-page">Enable</label>
                                            </div>
                                            <span class="input-note">Whether enable or disable the <strong>'My Token'</strong> page from User Panel.</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Stage Wise Overview</label>
                                            <div class="input-wrap input-wrap-switch">
                                                <input class="input-switch" name="user_mytoken_stage" type="checkbox" <?php echo e(gws('user_mytoken_stage') == 1 ? 'checked' : ''); ?> id="show-stage-overview">
                                                <label for="show-stage-overview">Show</label>
                                            </div>
                                            <span class="input-note">Whether show or hide the stage wise purchase overview on <strong>'My Token'</strong> page.</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="gaps-2x"></div>
                                <h5 class="card-title-sm text-secondary">Receiving Wallet for User Profile</h5>
                                <p class="wide-lg">You may need your user/investor wallet address so you can send token/smart contract to them. You can specify one or multiple or define your own name to ask your user/investor to provide address. If they provide then you can get from each user details.</p>
                                <div class="gaps-1x"></div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Supported Wallet</label>
                                            <div class="input-wrap">
                                                <select  name="token_wallet_opt[]" class="select select-block select-bordered" value="" data-placeholder="Select Options" multiple="multiple">
                                                    <?php $__currentLoopData = $supported_wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e(in_array($name, $wallet_opt )? 'selected' : ''); ?> value="<?php echo e($name); ?>"><?php echo e($wallet); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <span class="input-note">Choose one or multiple wallet name.</span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Custom Wallet</label>
                                            <div class="row">
                                                <div class="col-6">
                                                    <div class="input-wrap">
                                                        <input class="input-bordered" placeholder="wallet-name" type="text" name = "token_wallet_custom[]" value="<?php echo e((!empty($custom['cw_name']) ? $custom['cw_name'] : '')); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="input-wrap">
                                                        <input class="input-bordered" placeholder="Wallet Label" type="text" name="token_wallet_custom[]" value="<?php echo e((!empty($custom['cw_text']) ? $custom['cw_text'] : '')); ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <span class="input-note">You can specify any custom wallet name.</span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Note for Wallet</label>
                                            <div class="input-wrap">
                                                <input class="input-bordered" type="text" name="token_wallet_note" value="<?php echo e(get_setting('token_wallet_note')); ?>">
                                            </div>
                                            <span class="input-note">The note will show under the wallet address input field.</span>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-lg-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Before Purchase Alert</label>
                                            <div class="input-wrap input-wrap-switch">
                                                <input class="input-switch" name="token_wallet_req" type="checkbox" <?php echo e(get_setting('token_wallet_req')==1 ? 'checked ' : ''); ?>id="before-purchase-alert">
                                                <label for="before-purchase-alert"><span>Hide</span><span class="over">Show</span></label>
                                            </div>
                                            <div class="input-note">Promote 'enter wallet address before buy' on buy token page.</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="gaps-1x"></div>
                                <div class="d-flex">
                                    <button class="btn btn-primary save-disabled" type="submit" disabled><i class="ti ti-reload"></i><span>Update</span></button>
                                </div>
                            </form>
                        </div>
                        
                        <?php if(isset($modules) && !empty($modules)): ?>
                        <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!empty($opt->view)): ?>
                            <div class="sap sap-gap"></div>
                            <div class="card-text ico-setting setting-ico-userpanel">
                                <?php if ($__env->exists($opt->view, $opt->variables)) echo $__env->make($opt->view, $opt->variables, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/admin/ico-setting.blade.php ENDPATH**/ ?>