<?php
$pm_check = (!empty($methods) ? true : false);
$dot_1 =  '.'; $dot_2 = '';
if ($data->total_bonus > 0) {
    $dot_1 =  ''; $dot_2 = '.';
}
$activeMethods = data_get(get_defined_vars(), "activeMethods", []);
?>
<a href="#" class="modal-close" data-dismiss="modal"><em class="ti ti-close"></em></a>
<div class="popup-body">
    <div class="popup-content">
        <form class="validate-modern" action="<?php echo e(route('user.ajax.payment')); ?>" method="POST" id="online_payment">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="pp_token" id="token_amount" value="<?php echo e($data->token); ?>">
            <input type="hidden" name="pp_currency" id="pay_currency" value="<?php echo e($data->currency); ?>">
            <h4 class="popup-title"><?php echo e(__('Payment Process')); ?></h4>
            <p class="lead"><?php echo ($data->total_bonus > 0) ? __('Please make payment of :amount to receive :token_amount token including bonus :token_bonus token.', ['amount' => '<strong>'.to_num($data->amount, 'max').' <span class="pay-currency ucap">'.$data->currency.'</span></strong>', 'token_amount'=> '<strong><span class="token-total">'.to_num_token($data->total_tokens).' '.token('symbol').'</span></strong>', 'token_bonus'=> '<strong><span class="token-bonuses">'.to_num_token($data->total_bonus).' '.token('symbol').'</span></strong>']) : __('Please make payment of :amount to receive :token_amount token.', ['amount' => '<strong>'.to_num($data->amount, 'max').' <span class="pay-currency ucap">'.$data->currency.'</span></strong>', 'token_amount'=> '<strong><span class="token-total">'.to_num_token($data->total_tokens).' '.token('symbol').'</span></strong>']); ?>

            </p>
            <?php if($pm_check): ?>
                <p><?php echo e(__('You can choose any of following payment method to make your payment. The token balance will appear in your account after successful payment.')); ?></p>
                <h5 class="mgt-1-5x font-mid"><?php echo e(__('Select payment method:')); ?></h5>
                <ul class="pay-list guttar-12px">
                    <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($method); ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <p class="text-light font-italic mgb-1-5x"><small>* <?php echo e(__('Payment gateway may charge you a processing fees.')); ?></small></p>
                <div class="pdb-0-5x">
                    <div class="input-item text-left">
                        <input type="checkbox" data-msg-required="<?php echo e(__("You should accept our terms and policy.")); ?>" class="input-checkbox input-checkbox-md" id="agree-terms" name="agree" required>
                        <label for="agree-terms"><?php echo e(__('I hereby agree to the token purchase agreement and token sale term.')); ?></label>
                    </div>
                </div>
                <ul class="d-flex flex-wrap align-items-center guttar-30px">
                    <li><button type="submit" class="btn btn-alt btn-primary payment-btn"> <?php echo e(__('Buy Token Now')); ?> <em class="ti ti-arrow-right mgl-2x"></em></button></li>
                </ul>
                <div class="gaps-3x"></div>
                <div class="note note-plane note-light">
                    <em class="fas fa-info-circle"></em>
                    <p class="text-light"><?php echo e(__('Our payment address will appear or redirect you for payment after the order is placed.')); ?></p>
                </div>
            <?php else: ?>
                <div class="gaps-4x"></div>
                <div class="alert alert-danger text-center"><?php echo e(__('Sorry! There is no payment method available for this currency. Please choose another currency or contact our support team.')); ?></div>
                <div class="gaps-5x"></div>
            <?php endif; ?>

        </form>
    </div>
</div>
<?php if(in_array("Stripe", $activeMethods)): ?>
<script src="https://js.stripe.com/v3/"></script>
<?php endif; ?>
<script type="text/javascript">
    (function($) {
        var $_p_form = $('form#online_payment');
        if ($_p_form.length > 0) { purchase_form_submit($_p_form); }
    })(jQuery);
</script>
<?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/app/PayModule//views/payment.blade.php ENDPATH**/ ?>