<?php
    use Carbon\Carbon;

    $timezone = get_setting('site_timezone', 'UTC');
    $today_date = now()->timezone($timezone);
?>


<?php $__env->startSection('title', 'ICO/STO Stage'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
    <div class="container">
        <?php echo $__env->make('vendor.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="card content-area">
            <div class="card-innr">
                <div class="card-head d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">Available ICO/STO Stage</h4>
                    <a class="btn btn-sm btn-auto btn-primary d-sm-inline-block d-none" href="<?php echo e(route('admin.stages.create')); ?>">Add Stage</a>
                </div>
                <div class="gaps-1-5x"></div>
                <div class="row guttar-vr-30px">
                    <?php $__empty_1 = true; $__currentLoopData = $stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $start_date = Carbon::parse($stage->start_date, $timezone);
                            $end_date   = Carbon::parse($stage->end_date, $timezone);
                        ?>
                    <div class="col-xl-4 col-md-6">
                        <div class="stage-item stage-card <?php echo e((gws('actived_stage') == $stage->id)?'stage-item-actived':''); ?>">
                            <div class="stage-head">
                                <div class="stage-title">
                                    <h6>Stage Name 
                                    <?php if($today_date->gte($start_date) && $today_date->lte($end_date) && gws('actived_stage') == $stage->id && $stage->status != 'paused'): ?>
                                    <span class="badge badge-success">Running</span>
                                    <?php elseif($today_date->gte($start_date) && $today_date->lte($end_date) && $stage->status == 'paused'): ?>
                                    <span class="badge badge-purple">Paused</span>
                                    <?php elseif($today_date->gte($start_date) && $today_date->lte($end_date) && $stage->status != 'paused'): ?>
                                    <span class="badge badge-secondary">Inactive</span>
                                    <?php elseif($start_date->gt($today_date) && $today_date->lt($end_date)): ?>
                                    <span class="badge badge-warning">Upcoming</span>
                                    <?php elseif($start_date->gt($today_date) && $today_date->lt($end_date)): ?>
                                    <span class="badge badge-info">Completed</span>
                                    <?php else: ?>
                                    <span class="badge badge-danger">Expired</span>
                                    <?php endif; ?>
                                    <h4><?php echo e($stage->name); ?></h4>
                                </div>
                                
                                <div class="stage-action">
                                    <a href="#" class="toggle-tigger rotate"><em class="ti ti-more-alt"></em></a>
                                    <div class="toggle-class dropdown-content dropdown-content-top-left">
                                        <ul class="dropdown-list">
                                            <li><a href="javascript:void(0);" class="stages-ajax-action" data-action="overview" data-view="modal" data-stage="<?php echo e($stage->id); ?>">Overview</a></li>
                                            <li><a href="<?php echo e(route('admin.stages.edit', $stage->id)); ?>">Update Stage</a></li>

                                            <?php if(gws('actived_stage') != $stage->id): ?>
                                            <li><form action="<?php echo e(route('admin.ajax.stages.active')); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <a href="javascript:void(0);" id="update_stage" data-type="active_stage" data-id="<?php echo e($stage->id); ?>">Make as Active</a>
                                                <input class="input-bordered" type="hidden" name="actived_stage" value="<?php echo e($stage->id); ?>">
                                            </form></li>
                                            <?php endif; ?>
                                            <?php if($stage->status != 'paused'): ?>
                                            <li><form action="<?php echo e(route('admin.ajax.stages.pause')); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <a href="javascript:void(0);" id="update_stage" data-type="pause_stage" data-id="<?php echo e($stage->id); ?>">Sales Pause</a>
                                                <input class="input-bordered" type="hidden" name="stage_id" value="<?php echo e($stage->id); ?>">
                                                <input class="input-bordered" type="hidden" name="type" value="paused">
                                            </form></li>
                                            <?php endif; ?>
                                            <?php if($stage->status == 'paused'): ?>
                                            <li><form action="<?php echo e(route('admin.ajax.stages.pause')); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <a href="javascript:void(0);" id="update_stage" data-type="resume_stage" data-id="<?php echo e($stage->id); ?>">Sales Resume</a>
                                                <input class="input-bordered" type="hidden" name="stage_id" value="<?php echo e($stage->id); ?>">
                                                <input class="input-bordered" type="hidden" name="type" value="active">
                                            </form></li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="stage-info stage-info-status">
                                <div class="stage-info-graph">
                                    <?php if(!($start_date->gt($today_date) && $today_date->lt($end_date))): ?>
                                    <div class="progress-pie progress-circle">
                                        <input class="knob d-none" data-thickness=".125" data-width="100%" data-fgColor="#2b56f5" data-bgColor="#c8d2e5" value="<?php echo e(to_percent($stage->soldout, $stage->total_tokens)); ?>">
                                        <div class="progress-txt"><span class="progress-amount"><?php echo e(to_percent($stage->soldout, $stage->total_tokens)); ?></span>% <span class="progress-status">Sold</span></div>
                                    </div>
                                    <?php else: ?>
                                    <div class="progress-soon progress-circle">
                                        <div class="progress-txt"><span class="progress-status">Coming Soon</span></div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="stage-info-txt">
                                    <h6>Token Issued</h6>
                                    <span class="stage-info-total h4"><?php echo e(to_num_token($stage->total_tokens, 0)); ?></span>
                                    <div class="stage-info-count">Sold <span><?php echo e(to_num_token($stage->soldout, 0)); ?></span> Tokens</div>
                                </div>
                            </div>
                            <div class="stage-info">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="stage-info-txt">
                                            <h6>Base Price</h6>
                                            <div class="h2 stage-info-number"><?php echo e(to_num($stage->base_price, 'max')); ?><small><?php echo e(base_currency(true)); ?></small></div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="stage-info-txt">
                                            <h6>Base Bonus</h6>
                                            <div class="h2 stage-info-number"><?php echo e(stage_meta($stage->id)); ?><small>%</small></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="stage-date">
                                <div class="row">
                                    <div class="col-6">
                                        <h6>Start Date</h6>
                                        <h5><?php echo e(_date2sz($stage->start_date, gws('site_date_format'))); ?> <br><small><?php echo e(_date2sz($stage->start_date, gws('site_time_format'))); ?></small></h5>
                                    </div>
                                    <div class="col-6">
                                        <h6>End Date</h6>
                                        <h5><?php echo e(_date2sz($stage->end_date, gws('site_date_format'))); ?> <br><small><?php echo e(_date2sz($stage->end_date, gws('site_time_format'))); ?></small></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <span>No Stage Found</span>
                    <?php endif; ?>

                </div>
                <div class="gaps-0-5x"></div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/admin/ico-stage.blade.php ENDPATH**/ ?>