
<?php $__env->startSection('title', 'Page Manage'); ?>

<?php $__env->startPush('footer'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/plugins/trumbowyg/ui/trumbowyg.min.css')); ?>?ver=1.0">
<script src="<?php echo e(asset('assets/plugins/trumbowyg/trumbowyg.min.js')); ?>?ver=101"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<div class="page-content">
    <div class="container">
        <?php echo $__env->make('vendor.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="row">
            <div class="main-content col-lg-8">
                <div class="content-area card">
                    <div class="card-innr">
                        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <div class="card-head">
                            <h4 class="card-title">Pages List</h4>
                        </div>
                        <div class="gaps-1x"></div>
                        
                        <table class="table table-even-odd table-page">
                            <thead>
                                <tr>
                                    <th>Page Title</th>
                                    <th><span>Menu Name</span></th>
                                    <th>&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="page-<?php echo e($page->id); ?>">
                                    <td><h5><?php echo e(str_limit($page->title, 25)); ?></h5></td>
                                    <td><p><?php echo e($page->menu_title); ?></p></td>
                                    <td class="text-right">
                                        <ul>
                                            <li><a class="btn btn-circle btn-xs btn-icon btn-lighter" href="<?php echo e(route('admin.pages.edit', ['slug'=>$page->slug])); ?>" data-slug="<?php echo e($page->slug); ?>" ><em class="far fa-edit"></em></a></li>
                                        </ul>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                    </div> 

                </div> 
            </div>
            <div class="aside sidebar-right col-lg-4">
                <div class="token-sales card">
                    <div class="card-innr">
                        <div class="card no-hover-shadow">
                            <div class="card-head">
                                <h5 class="card-title-md">White Paper</h5>
                            </div>
                            <div class="sap"></div>
                            <div class="pdt-3x">
                                <h6>Upload your whitepaper here.</h6>
                                <div class="upload-box">
                                    <div class="wh-upload-zone whitepaper_upload">
                                        <div class="dz-message" data-dz-message>
                                            <span class="dz-message-text">Drag and drop file</span>
                                            <span class="dz-message-or">or</span>
                                            <button type="button" class="btn btn-primary">SELECT</button>
                                        </div>
                                    </div>
                                    <input type="hidden" name="whitepaper_file" accept="application/pdf" />
                                </div>
                                <small>Accept : pdf</small>
                                <div class="hiddenFiles"></div>
                                <div class="pt-3">
                                    <?php if(get_setting('site_white_paper') != ''): ?>
                                    <strong>White paper : </strong><a href="<?php echo e(route('public.white.paper')); ?>" target="_blank" ><?php echo e(get_setting('site_white_paper')); ?></a>
                                    <?php else: ?>
                                    <p class="text-light">No file uploaded yet!</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/admin/pages.blade.php ENDPATH**/ ?>