
<?php $__env->startSection('title', 'Transaction Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
    <div class="container">
        <div class="card content-area">
            <div class="card-innr">
                <div class="card-head d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">Transaction Details <em class="ti ti-angle-right fs-14"></em> <small class="tnx-id"><?php echo e($trnx->tnx_id); ?></small></h4>
                    <a href="<?php echo e((url()->previous()) ? url()->previous() : route('admin.transactions')); ?>" class="btn btn-sm btn-auto btn-primary"><em class="fas fa-arrow-left"></em><span class="d-sm-inline-block d-none">Back</span></a>
                </div>
                <div class="gaps-1-5x"></div>
                <div class="data-details d-md-flex">
                    <div class="fake-class">
                        <span class="data-details-title">Transaction Date</span>
                        <span class="data-details-info"><?php echo e(_date($trnx->tnx_time)); ?></span>
                    </div>
                    <div class="fake-class">
                        <span class="data-details-title">Transaction Status</span>
                        <span class="badge badge-<?php echo e(__status($trnx->status, 'status')); ?> ucap"><?php echo e($trnx->status); ?></span>
                    </div>
                    <div class="fake-class">
                        <span class="data-details-title">Transaction by</span>

                        <span class="data-details-info"><strong><?php echo e(transaction_by($trnx->added_by)); ?></strong></span>
                    </div>
                    <div class="fake-class">
                        <?php if($trnx->tnx_type=='refund'): ?>
                            <?php
                            $trnx_extra = (is_json($trnx->extra, true) ?? $trnx->extra);
                            ?>
                            <span class="data-details-title">Refund Note</span>
                            <span class="data-details-info"><?php echo e($trnx_extra->message); ?></span>
                        <?php else: ?>
                            <span class="data-details-title">Transaction Note</span>
                            <?php if($trnx->checked_by != NULL): ?>
                            <span class="data-details-info"><?php echo e(ucfirst($trnx->status)); ?> By <strong><?php echo e(ucfirst(approved_by($trnx->checked_by))); ?></strong> <br> at <?php echo e(_date($trnx->checked_time)); ?></span>
                            <?php elseif($trnx->status == 'canceled'): ?>
                            <span class="data-details-info">Canceled by User</span>
                            <?php else: ?>
                            <span class="data-details-info">Not Reviewed yet.</span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="gaps-3x"></div>
                <h6 class="card-sub-title">Transaction Info</h6>
                <ul class="data-details-list">
                    <li>
                        <div class="data-details-head">Transaction Type</div>
                        <div class="data-details-des"><strong><?php echo e(ucfirst($trnx->tnx_type)); ?></strong></div>
                    </li>
                    <?php if(($trnx->tnx_type=='referral'||$trnx->tnx_type=='bonus') && $trnx->added_by==set_added_by('0')): ?>
                    <li>
                        <div class="data-details-head"><?php echo e(($trnx->tnx_type=='bonus') ? 'Referred By' : 'Referral Bonus For'); ?></div>
                        <div class="data-details-des">
                            <span><?php echo e(set_id(referral_info($trnx->extra, 'id'))); ?> <small> - <?php echo e(explode_user_for_demo( referral_info($trnx->extra, 'email'), auth()->user()->type)); ?></small></span>
                            <span><strong><a href="<?php echo e(route('admin.transactions.view', get_tnx_id($trnx->extra))); ?>"><?php echo e(get_meta($trnx->extra, 'tnx_id')); ?></a></strong></span>
                        </div>
                    </li>
                    <li>
                        <div class="data-details-head">Bonus Apply</div>
                        <div class="data-details-des">
                            <span><?php echo e(get_meta($trnx->extra, 'bonus')); ?><?php echo e((get_meta($trnx->extra, 'calc') =='percent' ? '%' : ' (Fixed)')); ?><?php echo e((get_meta($trnx->extra, 'level') ? ' - '.strtoupper(get_meta($trnx->extra, 'level')) : '' )); ?></span>
                            <span><?php echo e(get_meta($trnx->extra, 'tokens').' '.token_symbol()); ?></span>
                        </div>
                    </li>
                    <?php endif; ?>

                    <?php if($trnx->tnx_type=='purchase'): ?>
                    <li>
                        <div class="data-details-head">Payment Gateway</div>
                        <div class="data-details-des">
                            <strong><?php echo e(ucfirst($trnx->payment_method)); ?> <small>- <?php echo e(gateway_type($trnx->payment_method)); ?></small></strong>
                            <?php
                                $statusUrl = data_get(get_meta($trnx->extra, 'result'), 'status_url');
                            ?>
                            <?php if($statusUrl && $trnx->status == 'pending'): ?>
                                <span><a href="<?php echo e($statusUrl); ?>" target="_blank" rel="noopener noreferrer">Check Status</a></span>
                            <?php endif; ?>
                        </div>
                    </li>
                    <li>
                        <div class="data-details-head">Deposit From</div>
                        <div class="data-details-des"><strong><?php echo $trnx->wallet_address ? $trnx->wallet_address : '~'; ?></strong></div>
                    </li>
                    <?php if($trnx->payment_to): ?>
                    <li>
                        <div class="data-details-head">Deposit To (<?php echo e(( ($trnx->payment_method=='manual') ? short_to_full($trnx->currency) : ucfirst($trnx->payment_method) )); ?>)</div>
                        <div class="data-details-des"><span><?php echo $trnx->payment_to ? $trnx->payment_to : '~'; ?> <?php echo (get_meta($trnx->extra, 'network') && get_meta($trnx->extra, 'network') != 'default') ? '('.short_to_full(get_meta($trnx->extra, 'network')).')' : ''; ?></span></div>
                    </li>
                    <?php endif; ?>
                    <li>
                        <div class="data-details-head">Payable Amount</div>
                        <div class="data-details-des">
                            <span><strong><?php echo e(to_num($trnx->amount, 'max').' '.strtoupper($trnx->currency)); ?></strong></span>
                        </div>
                    </li>
                    <li>
                        <div class="data-details-head">Received Amount</div>
                        <div class="data-details-des">
                            <span><strong><?php echo e(to_num($trnx->receive_amount, 'max').' '.strtoupper($trnx->currency)); ?></strong></span>
                        </div>
                    </li>
                    <?php endif; ?>

                    <?php if($trnx->tnx_type=='refund'): ?>
                    <li>
                        <div class="data-details-head">Refund Amount</div>
                        <div class="data-details-des">
                            <span><strong class="text-danger"><?php echo e('-'.to_num(abs($trnx->amount), 'max').' '.strtoupper($trnx->currency)); ?></strong></span>
                        </div>
                    </li>
                    <?php endif; ?>
                    <li>
                        <div class="data-details-head">Details</div>
                        <div class="data-details-des"><?php echo $trnx->details ? $trnx->details : '&nbsp;'; ?></div>
                    </li>
                </ul>
                <div class="gaps-3x"></div>
                <h6 class="card-sub-title">Token Details</h6>
                <ul class="data-details-list">
                    <?php if($trnx->ico_stage): ?>
                    <li>
                        <div class="data-details-head">Stage Name</div>
                        <div class="data-details-des"><strong><?php echo e($trnx->ico_stage->name); ?></strong></div>
                    </li>
                    <?php endif; ?>
                    <?php if($trnx->tnx_type=='purchase'): ?>
                    <li>
                        <div class="data-details-head">Contribution</div>
                        <div class="data-details-des">
                            <span><strong><?php echo e(to_num($trnx->amount, 'max').' '.strtoupper($trnx->currency)); ?></strong> <em class="fas fa-info-circle" data-toggle="tooltip" data-placement="bottom" title="1 <?php echo e(token('symbol')); ?> = <?php echo e(to_num($trnx->currency_rate, 'max').' '.strtoupper($trnx->currency)); ?>"></em></span>
                            <span><em class="fas fa-info-circle" data-toggle="tooltip" data-placement="bottom" title="1 <?php echo e(token('symbol')); ?> = <?php echo e(to_num($trnx->base_currency_rate, 'max').' '.strtoupper($trnx->base_currency)); ?>"></em> <?php echo e(to_num($trnx->base_amount, 'max')); ?> <?php echo e(strtoupper($trnx->base_currency)); ?></span>
                        </div>
                    </li>
                    <?php endif; ?>
                    <li>
                        <div class="data-details-head">Token <?php echo e(($trnx->tnx_type=='refund') ? 'Refund' : 'Added'); ?> To</div>
                        <div class="data-details-des">
                            <span><strong><?php echo e(set_id($trnx->user)); ?>

                                <small> - <?php echo e(isset($trnx->tnxUser) ? explode_user_for_demo($trnx->tnxUser->email, auth()->user()->type) : '...'); ?></small>
                            </strong></span>
                            <span><?php echo isset($trnx->tnxUser->walletAddress) ? '<em class="fas fa-info-circle" data-toggle="tooltip" data-placement="top" title="Profile Receiving Wallet ('.ucfirst($trnx->tnxUser->walletType).')"></em> '.$trnx->tnxUser->walletAddress : ''; ?></span>
                        </div>
                    </li>
                    <?php if($trnx->tnx_type!='refund'): ?>
                    <li>
                        <div class="data-details-head">Token (T)</div>
                        <div class="data-details-des">
                            <span><?php echo e(to_num($trnx->tokens, 'min', '', false)); ?> <?php echo e(token_symbol()); ?></span>
                        </div>
                    </li>
                    <?php endif; ?>
                    <?php if($trnx->tnx_type=='purchase'): ?>
                    <li>
                        <div class="data-details-head">Bonus Tokens (B)</div>
                        <div class="data-details-des">
                            <span><?php echo e(to_num($trnx->total_bonus, 'min', '', false)); ?> <?php echo e(token_symbol()); ?></span>
                            <span>(<?php echo e(to_num($trnx->bonus_on_token)); ?> + <?php echo e(to_num($trnx->bonus_on_base)); ?>)</span>
                        </div>
                    </li>
                    <li>
                        <div class="data-details-head">Total Token</div>
                        <div class="data-details-des">
                            <span><strong><?php echo e(to_num($trnx->total_tokens, 'min', '', false)); ?> <?php echo e(token_symbol()); ?></strong></span>
                            <span>(T+B)</span>
                        </div>
                    </li>
                    <?php endif; ?>
                    <?php if($trnx->tnx_type=='refund'): ?>
                    <li>
                        <div class="data-details-head">Refund Token</div>
                        <div class="data-details-des">
                            <span><strong class="text-danger"><?php echo e('-'.to_num(abs($trnx->total_tokens), 'max')); ?> <?php echo e(token_symbol()); ?></strong></span>
                        </div>
                    </li>
                    <?php endif; ?>

                </ul>
                <div class="gaps-0-5x"></div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/admin/trnx_details.blade.php ENDPATH**/ ?>