
<?php $__env->startSection('title', __('Sign up')); ?>
<?php $__env->startSection('content'); ?>

<?php
$check_users = \App\Models\User::count();
?>
<?php if( recaptcha() ): ?>
<?php $__env->startPush('header'); ?>
<script>
    grecaptcha.ready(function () { grecaptcha.execute('<?php echo e(recaptcha('site')); ?>', { action: 'register' }).then(function (token) { if(token) { document.getElementById('recaptcha').value = token; } }); });
</script>
<?php $__env->stopPush(); ?>
<?php endif; ?>
<div class="page-ath-form">

    <h2 class="page-ath-heading"><?php echo e(__('Sign up')); ?> <small><?php echo e(__('Create New')); ?> <?php echo e(site_info('name')); ?> <?php echo e(__('Account')); ?></small></h2>
    <form class="register-form" method="POST" action="<?php echo e(route('register')); ?>" id="register">
        <?php echo csrf_field(); ?>
        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if(! is_maintenance() && application_installed(true) && ($check_users == 0) ): ?>
        <div class="alert alert-info-alt">
            Please register first your Super Admin account with adminstration privilege.
        </div>
        <?php endif; ?>
        <div class="input-item">
            <input type="text" placeholder="<?php echo e(__('Your Name')); ?>" class="input-bordered<?php echo e($errors->has('name') ? ' input-error' : ''); ?>" name="name" value="<?php echo e(old('name')); ?>" minlength="3" data-msg-required="<?php echo e(__('Required.')); ?>" data-msg-minlength="<?php echo e(__('At least :num chars.', ['num' => 3])); ?>" required>
        </div>
        <div class="input-item">
            <input type="email" placeholder="<?php echo e(__('Your Email')); ?>" class="input-bordered<?php echo e($errors->has('email') ? ' input-error' : ''); ?>" name="email" value="<?php echo e(old('email')); ?>"data-msg-required="<?php echo e(__('Required.')); ?>" data-msg-email="<?php echo e(__('Enter valid email.')); ?>" required>
        </div>
        <div class="input-item">
            <input type="password" placeholder="<?php echo e(__('Password')); ?>" class="input-bordered<?php echo e($errors->has('password') ? ' input-error' : ''); ?>" name="password" id="password" minlength="6" data-msg-required="<?php echo e(__('Required.')); ?>" data-msg-minlength="<?php echo e(__('At least :num chars.', ['num' => 6])); ?>" required>
        </div>
        <div class="input-item">
            <input type="password" placeholder="<?php echo e(__('Repeat Password')); ?>" class="input-bordered<?php echo e($errors->has('password_confirmation') ? ' input-error' : ''); ?>" name="password_confirmation" data-rule-equalTo="#password" minlength="6" data-msg-required="<?php echo e(__('Required.')); ?>" data-msg-equalTo="<?php echo e(__('Enter the same value.')); ?>" data-msg-minlength="<?php echo e(__('At least :num chars.', ['num' => 6])); ?>" required>
        </div>
        <?php if( gws('referral_info_show')==1 && get_refer_id() ): ?>
        <div class="input-item">
            <input type="text" class="input-bordered" value="<?php echo e(__('Your were invited by :userid', ['userid' => get_refer_id(true)])); ?>" disabled readonly>
        </div>
        <?php endif; ?>
        
        <?php if(( application_installed(true)) && ($check_users > 0)): ?>
            <?php if(get_page_link('terms') || get_page_link('policy')): ?>
            <div class="input-item text-left">
                <input name="terms" class="input-checkbox input-checkbox-md" id="agree" type="checkbox" required="required" data-msg-required="<?php echo e(__("You should accept our terms and policy.")); ?>">
                <label for="agree"><?php echo __('I agree to the') . ' ' .get_page_link('terms', ['target'=>'_blank', 'name' => true, 'status' => true]) . ((get_page_link('terms', ['status' => true]) && get_page_link('policy', ['status' => true])) ? ' '.__('and').' ' : '') . get_page_link('policy', ['target'=>'_blank', 'name' => true, 'status' => true]); ?>.</label>
            </div>
            <?php else: ?>
            <div class="input-item text-left">
                <label for="agree"><?php echo e(__('By registering you agree to the terms and conditions.')); ?></label>
            </div>
            <?php endif; ?>
        <?php else: ?>
            <input name="terms" value="1" type="hidden">
        <?php endif; ?>
        <?php if( recaptcha() ): ?>
        <input type="hidden" name="recaptcha" id="recaptcha">
        <?php endif; ?>
        <button type="submit" class="btn btn-primary btn-block"><?php echo e(( application_installed(true) && ($check_users == 0) ) ? __('Complete Installation') : __('Create Account')); ?></button>
    </form>

    <?php if(application_installed(true) && ($check_users > 0) && Schema::hasTable('settings')): ?>
        <?php if(
        (get_setting('site_api_fb_id', env('FB_CLIENT_ID', '')) != '' && get_setting('site_api_fb_secret', env('FB_CLIENT_SECRET', '')) != '') ||
        (get_setting('site_api_google_id', env('GOOGLE_CLIENT_ID', '')) != '' && get_setting('site_api_google_secret', env('GOOGLE_CLIENT_SECRET', '')) != '')
        ): ?>
        <div class="sap-text"><span><?php echo e(__('Or Sign up with')); ?></span></div>
        <ul class="row guttar-20px guttar-vr-20px">
            <li class="col"><a href="<?php echo e(route('social.login', 'facebook')); ?>" class="btn btn-outline btn-dark btn-facebook btn-block"><em class="fab fa-facebook-f"></em><span><?php echo e(__('Facebook')); ?></span></a></li>
            <li class="col"><a href="<?php echo e(route('social.login', 'google')); ?>" class="btn btn-outline btn-dark btn-google btn-block"><em class="fab fa-google"></em><span><?php echo e(__('Google')); ?></span></a></li>
        </ul>
        <?php endif; ?>

        <div class="gaps-4x"></div>
        <div class="form-note">
            <?php echo e(__('Already have an account ?')); ?> <a href="<?php echo e(route('login')); ?>"> <strong><?php echo e(__('Sign in instead')); ?></strong></a>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/auth/register.blade.php ENDPATH**/ ?>