
<?php $__env->startSection('title', 'Edit Page'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
    <div class="container">
        <div class="card content-area">
            <div class="card-innr">
                <div class="card-head has-aside">
                    <h4 class="card-title">Edit Page "<span class="text-primary"><?php echo e($page_data->menu_title); ?></span>"</h4>
                    <div class="card-opt">
                        <ul class="btn-grp btn-grp-block guttar-20px">
                            <li>
                                <a href="<?php echo e(route('admin.pages')); ?>" class="btn btn-auto btn-outline btn-primary btn-sm"><i class="fas fa-arrow-left"></i><span>Back</span></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <form action="<?php echo e(route('admin.ajax.pages.update')); ?>" class="validate-modern" method="POST" id="update_page">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="page_id" value="<?php echo e($page_data->id); ?>">
                    <div class="msg-box"></div>
                    <div class="input-item input-with-label">
                        <label for="menu_title" class="input-item-label">Menu Name</label>
                        <div class="input-wrap">
                            <input name="menu_title" id="menu_title" class="input-bordered" required value="<?php echo e($page_data->menu_title); ?>" type="text">
                        </div>
                    </div>
                    <div class="input-item input-with-label">
                        <label for="menu_title" class="input-item-label">Slug</label>
                        <div class="input-wrap">
                            <input name="custom_slug" id="custom_slug" class="input-bordered" required value="<?php echo e($page_data->custom_slug); ?>"<?php echo e(($page_data->slug=='referral') ? ' readonly' : ''); ?> type="text">
                        </div>
                    </div>
                    <div class="input-item input-with-label">
                        <label for="title" class="input-item-label">Page Title</label>
                        <div class="input-wrap">
                            <input name="title" id="title" class="input-bordered" value="<?php echo e($page_data->title); ?>" type="text" required="">
                        </div>
                    </div>
                    <div class="input-item  input-with-label">
                        <label for="description" class="input-item-label">Page Content</label>
                        <div class="input-wrap">
                            <textarea id="description" name="description" class="input-bordered input-textarea editor" ><?php echo e($page_data->description); ?></textarea>
                            <span class="input-note"><strong>Available Short-codes : </strong> [[token_name]], [[token_symbol]], [[site_name]], [[site_email]], [[whitepaper_download_link]], [[whitepaper_download_button]]</span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6 col-sm-3">
                            <div class="input-item input-with-label">
                                <label for="status" class="input-item-label">Visibility</label>
                                <select name="status" id="status" class="select select-bordered select-block">
                                    <option <?php echo e($page_data->status == 'active' ? 'selected' : ''); ?> value="active">Show</option>
                                    <option <?php echo e($page_data->status == 'hide' ? 'selected' : ''); ?> value="hide">Hide</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="gaps-1x"></div>
                    <button type="submit" class="btn btn-md btn-primary ucap">Update Page</button>
                </form>

            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/plugins/trumbowyg/ui/trumbowyg.min.css')); ?>?ver=1.0">
<script src="<?php echo e(asset('assets/plugins/trumbowyg/trumbowyg.min.js')); ?>?ver=101"></script>

<script type="text/javascript">
    (function($) {
        if($('.editor').length > 0){
            $('.editor').trumbowyg({autogrow: true});
        }
        var $_form = $('form#update_page');
        if ($_form.length > 0) {
            ajax_form_submit($_form, false);
        }
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oakcsujh/genevaxchange.com/tokenlite_app/resources/views/admin/edit-page.blade.php ENDPATH**/ ?>